/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.runtime.TldScanner;

public final class EmbeddedServletOptions
implements Options {
    private static Logger log = Logger.getLogger(EmbeddedServletOptions.class.getName());
    private Properties settings;
    private boolean development;
    public boolean fork;
    private boolean keepGenerated;
    private boolean saveBytecode;
    private boolean trimSpaces;
    private boolean isPoolingEnabled;
    private boolean mappedFile;
    private boolean sendErrorToClient;
    private boolean classDebugInfo;
    private int checkInterval;
    private boolean isSmapSuppressed;
    private boolean isSmapDumped;
    private boolean genStringAsCharArray;
    private boolean genStringAsByteArray;
    private boolean defaultBufferNone;
    private boolean errorOnUseBeanInvalidClassAttribute;
    private File scratchDir;
    private String ieClassId;
    private String classpath;
    private String sysClassPath;
    private String compiler;
    private String compilerTargetVM;
    private String compilerSourceVM;
    private TldScanner tldScanner;
    private JspConfig jspConfig;
    private TagPluginManager tagPluginManager;
    private String javaEncoding;
    private int modificationTestInterval;
    private boolean xpoweredBy;
    private boolean usePrecompiled;
    private boolean isValidationEnabled;
    private int initialCapacity;

    public String getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public void setProperty(String name, String value) {
        if (name != null && value != null) {
            this.settings.setProperty(name, value);
        }
    }

    @Override
    public boolean getKeepGenerated() {
        return this.keepGenerated;
    }

    @Override
    public boolean getSaveBytecode() {
        return this.saveBytecode;
    }

    @Override
    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    @Override
    public boolean isPoolingEnabled() {
        return this.isPoolingEnabled;
    }

    @Override
    public boolean getMappedFile() {
        return this.mappedFile;
    }

    @Override
    public boolean getSendErrorToClient() {
        return this.sendErrorToClient;
    }

    @Override
    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    @Override
    public int getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public int getModificationTestInterval() {
        return this.modificationTestInterval;
    }

    @Override
    public boolean getDevelopment() {
        return this.development;
    }

    @Override
    public boolean isSmapSuppressed() {
        return this.isSmapSuppressed;
    }

    @Override
    public boolean isSmapDumped() {
        return this.isSmapDumped;
    }

    @Override
    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    @Override
    public boolean genStringAsByteArray() {
        return this.genStringAsByteArray;
    }

    @Override
    public boolean isDefaultBufferNone() {
        return this.defaultBufferNone;
    }

    @Override
    public String getIeClassId() {
        return this.ieClassId;
    }

    @Override
    public File getScratchDir() {
        return this.scratchDir;
    }

    @Override
    public String getClassPath() {
        return this.classpath;
    }

    @Override
    public String getSystemClassPath() {
        return this.sysClassPath;
    }

    @Override
    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    @Override
    public String getCompiler() {
        return this.compiler;
    }

    @Override
    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    @Override
    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    @Override
    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    @Override
    public TldScanner getTldScanner() {
        return this.tldScanner;
    }

    @Override
    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    @Override
    public boolean getFork() {
        return this.fork;
    }

    @Override
    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    @Override
    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public boolean getUsePrecompiled() {
        return this.usePrecompiled;
    }

    @Override
    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public EmbeddedServletOptions(ServletConfig config, ServletContext context) {
        String jspCompilerPlugin;
        String msg;
        block42: {
            String capacity;
            String usePrecompiled;
            String reloadIntervalString;
            String javaEncoding;
            String compilerSourceVM;
            String dir;
            String sysClassPath;
            String classpath;
            String ieClassId;
            String modificationTestIntervalStr;
            this.settings = new Properties();
            this.development = true;
            this.fork = true;
            this.saveBytecode = false;
            this.trimSpaces = false;
            this.isPoolingEnabled = true;
            this.mappedFile = true;
            this.sendErrorToClient = false;
            this.classDebugInfo = true;
            this.checkInterval = 0;
            this.isSmapSuppressed = false;
            this.isSmapDumped = false;
            this.genStringAsCharArray = false;
            this.genStringAsByteArray = true;
            this.defaultBufferNone = false;
            this.errorOnUseBeanInvalidClassAttribute = false;
            this.ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
            this.classpath = null;
            this.sysClassPath = null;
            this.compiler = null;
            this.compilerTargetVM = "1.5";
            this.compilerSourceVM = "1.5";
            this.tldScanner = null;
            this.jspConfig = null;
            this.tagPluginManager = null;
            this.javaEncoding = "UTF8";
            this.modificationTestInterval = 0;
            this.initialCapacity = 32;
            try {
                if ((double)Float.parseFloat(System.getProperty("java.specification.version")) > 1.4) {
                    this.compilerTargetVM = "1.5";
                    this.compilerSourceVM = "1.5";
                } else {
                    this.compilerTargetVM = "1.4";
                    this.compilerSourceVM = "1.4";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Enumeration enumeration = config.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String k = (String)enumeration.nextElement();
                String v = config.getInitParameter(k);
                this.setProperty(k, v);
            }
            String validating = config.getInitParameter("validating");
            if ("true".equals(validating)) {
                this.isValidationEnabled = true;
            }
            if ("true".equals(validating = config.getInitParameter("enableTldValidation"))) {
                this.isValidationEnabled = true;
            }
            this.keepGenerated = this.getBoolean(config, !this.isJDK6(), "keepgenerated");
            this.saveBytecode = this.getBoolean(config, this.saveBytecode, "saveBytecode");
            this.trimSpaces = this.getBoolean(config, this.trimSpaces, "trimSpaces");
            this.isPoolingEnabled = this.getBoolean(config, this.isPoolingEnabled, "enablePooling");
            this.mappedFile = this.getBoolean(config, this.mappedFile, "mappedfile");
            this.sendErrorToClient = this.getBoolean(config, this.sendErrorToClient, "sendErrToClient");
            this.classDebugInfo = this.getBoolean(config, this.classDebugInfo, "classdebuginfo");
            this.development = this.getBoolean(config, this.development, "development");
            this.isSmapSuppressed = this.getBoolean(config, this.isSmapSuppressed, "suppressSmap");
            this.isSmapDumped = this.getBoolean(config, this.isSmapDumped, "dumpSmap");
            this.genStringAsCharArray = this.getBoolean(config, this.genStringAsCharArray, "genStrAsCharArray");
            this.genStringAsByteArray = this.getBoolean(config, this.genStringAsByteArray, "genStrAsByteArray");
            this.defaultBufferNone = this.getBoolean(config, this.defaultBufferNone, "defaultBufferNone");
            this.errorOnUseBeanInvalidClassAttribute = this.getBoolean(config, this.errorOnUseBeanInvalidClassAttribute, "errorOnUseBeanInvalidClassAttribute");
            this.fork = this.getBoolean(config, this.fork, "fork");
            this.xpoweredBy = this.getBoolean(config, this.xpoweredBy, "xpoweredBy");
            String checkIntervalStr = config.getInitParameter("checkInterval");
            if (checkIntervalStr != null) {
                this.parseCheckInterval(checkIntervalStr);
            }
            if ((modificationTestIntervalStr = config.getInitParameter("modificationTestInterval")) != null) {
                this.parseModificationTestInterval(modificationTestIntervalStr);
            }
            if ((ieClassId = config.getInitParameter("ieClassId")) != null) {
                this.ieClassId = ieClassId;
            }
            if ((classpath = config.getInitParameter("classpath")) != null) {
                this.classpath = classpath;
            }
            if ((sysClassPath = config.getInitParameter("com.sun.appserv.jsp.classpath")) != null) {
                this.sysClassPath = sysClassPath;
            }
            if ((dir = config.getInitParameter("scratchdir")) != null) {
                this.scratchDir = new File(dir);
            } else {
                this.scratchDir = (File)context.getAttribute("javax.servlet.context.tempdir");
                if (this.scratchDir == null && (dir = System.getProperty("java.io.tmpdir")) != null) {
                    this.scratchDir = new File(dir);
                }
            }
            if (this.scratchDir == null) {
                log.severe(Localizer.getMessage("jsp.error.no.scratch.dir"));
                return;
            }
            if (!(!this.scratchDir.exists() || this.scratchDir.canRead() && this.scratchDir.canWrite() && this.scratchDir.isDirectory())) {
                log.severe(Localizer.getMessage("jsp.error.bad.scratch.dir", this.scratchDir.getAbsolutePath()));
            }
            this.compiler = config.getInitParameter("compiler");
            String compilerTargetVM = config.getInitParameter("compilerTargetVM");
            if (compilerTargetVM != null) {
                this.compilerTargetVM = compilerTargetVM;
            }
            if ((compilerSourceVM = config.getInitParameter("compilerSourceVM")) != null) {
                this.compilerSourceVM = compilerSourceVM;
            }
            if ((javaEncoding = config.getInitParameter("javaEncoding")) != null) {
                this.javaEncoding = javaEncoding;
            }
            if ((reloadIntervalString = config.getInitParameter("reload-interval")) != null) {
                int reloadInterval;
                block41: {
                    reloadInterval = 0;
                    try {
                        reloadInterval = Integer.parseInt(reloadIntervalString);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isLoggable(Level.WARNING)) break block41;
                        log.warning(Localizer.getMessage("jsp.warning.reloadInterval"));
                    }
                }
                if (reloadInterval == -1) {
                    this.development = false;
                    this.checkInterval = 0;
                } else {
                    this.parseCheckInterval(reloadIntervalString);
                    this.parseModificationTestInterval(reloadIntervalString);
                }
            }
            if ((usePrecompiled = config.getInitParameter("usePrecompiled")) == null) {
                usePrecompiled = config.getInitParameter("use-precompiled");
            }
            if (usePrecompiled != null) {
                if (usePrecompiled.equalsIgnoreCase("true")) {
                    this.usePrecompiled = true;
                } else if (usePrecompiled.equalsIgnoreCase("false")) {
                    this.usePrecompiled = false;
                } else if (log.isLoggable(Level.WARNING)) {
                    log.warning(Localizer.getMessage("jsp.warning.usePrecompiled"));
                }
            }
            if ((capacity = config.getInitParameter("initialCapacity")) == null) {
                capacity = config.getInitParameter("initial-capacity");
            }
            if (capacity != null) {
                try {
                    int value;
                    this.initialCapacity = Integer.parseInt(capacity);
                    for (value = 32; value < this.initialCapacity; value *= 2) {
                    }
                    this.initialCapacity = value;
                }
                catch (NumberFormatException nfe) {
                    if (!log.isLoggable(Level.WARNING)) break block42;
                    msg = Localizer.getMessage("jsp.warning.initialcapacity");
                    msg = MessageFormat.format(msg, capacity, 32);
                    log.warning(msg);
                }
            }
        }
        if ((jspCompilerPlugin = config.getInitParameter("javaCompilerPlugin")) != null) {
            if ("org.apache.jasper.compiler.JikesJavaCompiler".equals(jspCompilerPlugin)) {
                this.compiler = "jikes";
            } else if (!"org.apache.jasper.compiler.SunJava14Compiler".equals(jspCompilerPlugin) && log.isLoggable(Level.WARNING)) {
                msg = Localizer.getMessage("jsp.warning.unsupportedJavaCompiler");
                msg = MessageFormat.format(msg, jspCompilerPlugin);
                log.warning(msg);
            }
        }
        this.tldScanner = new TldScanner(context, this.isValidationEnabled);
        this.jspConfig = new JspConfig(context);
        this.tagPluginManager = new TagPluginManager(context);
    }

    private void parseCheckInterval(String param) {
        block2: {
            try {
                this.checkInterval = Integer.parseInt(param);
            }
            catch (NumberFormatException ex) {
                if (!log.isLoggable(Level.WARNING)) break block2;
                log.warning(Localizer.getMessage("jsp.warning.checkInterval"));
            }
        }
    }

    private void parseModificationTestInterval(String param) {
        block2: {
            try {
                this.modificationTestInterval = Integer.parseInt(param);
            }
            catch (NumberFormatException ex) {
                if (!log.isLoggable(Level.WARNING)) break block2;
                log.warning(Localizer.getMessage("jsp.warning.modificationTestInterval"));
            }
        }
    }

    private boolean getBoolean(ServletConfig config, boolean init, String param) {
        String sParam = config.getInitParameter(param);
        if (sParam != null) {
            if (sParam.equalsIgnoreCase("true")) {
                return true;
            }
            if (sParam.equalsIgnoreCase("false")) {
                return false;
            }
            if (log.isLoggable(Level.WARNING)) {
                log.warning(Localizer.getMessage("jsp.warning.boolean", param, init ? "true" : "false"));
            }
        }
        return init;
    }

    private boolean isJDK6() {
        return "1.6".equals(System.getProperty("java.specification.version"));
    }
}

