/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.base.AbstractIterator;
import kala.collection.base.Iterators;
import kala.collection.base.ObjectArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.control.Option;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedFunction;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenericArrays {
    public static final Object[] EMPTY_OBJECT_ARRAY = ObjectArrays.EMPTY;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private GenericArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static <E> IntFunction<E[]> generator(@NotNull Class<E> type) {
        Objects.requireNonNull(type);
        return type == Object.class ? ObjectArrays.generator() : length -> GenericArrays.create(type, length);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> CollectionFactory<E, ?, E[]> factory(@NotNull Class<E> componentType) {
        Objects.requireNonNull(componentType);
        return new Factory<E>(componentType);
    }

    @NotNull
    public static <E> Class<E[]> arrayType(@NotNull Class<E> type) {
        return type == Object.class ? Object[].class : Array.newInstance(type, 0).getClass();
    }

    public static <E> E @NotNull [] create(@NotNull Class<E> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> E @NotNull [] of(E ... values) {
        return values;
    }

    public static <E> E @NotNull [] of(@NotNull Class<E> type, E ... values) {
        return GenericArrays.from(type, values);
    }

    public static <E> E @NotNull [] from(E @NotNull [] values) {
        return (Object[])values.clone();
    }

    public static <E> E @NotNull [] from(@NotNull Class<E> type, E[] values) {
        int length = values.length;
        E[] res = GenericArrays.create(type, length);
        System.arraycopy(values, 0, res, 0, length);
        return res;
    }

    public static <E> E @NotNull [] from(@NotNull Class<E> type, @NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(type);
        if (values instanceof Collection) {
            return ((Collection)values).toArray(GenericArrays.create(type, 0));
        }
        if (values instanceof Traversable) {
            return ((Traversable)values).toArray(type);
        }
        ArrayList<E> tmp = new ArrayList<E>();
        for (E e : values) {
            tmp.add(e);
        }
        return tmp.toArray(GenericArrays.create(type, 0));
    }

    public static <E> E @NotNull [] from(@NotNull Class<E> type, @NotNull Iterator<? extends E> it) {
        return Iterators.toArray(it, type);
    }

    public static <E> E @NotNull [] from(@NotNull Class<E> type, @NotNull Stream<? extends E> stream) {
        return stream.toArray(GenericArrays.generator(type));
    }

    public static <E> E @NotNull [] fill(@NotNull Class<E> type, int n, E value) {
        if (n <= 0) {
            return GenericArrays.create(type, 0);
        }
        Object[] ans = GenericArrays.create(type, n);
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return ans;
    }

    public static <E> E @NotNull [] fill(@NotNull Class<E> type, int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return GenericArrays.create(type, 0);
        }
        E[] ans = GenericArrays.create(type, n);
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return ans;
    }

    public static <E> E @NotNull [] fill(@NotNull Class<E> type, int n, @NotNull IntFunction<? extends E> supplier) {
        if (n <= 0) {
            return GenericArrays.create(type, 0);
        }
        E[] ans = GenericArrays.create(type, n);
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.apply(i);
        }
        return ans;
    }

    public static <E> E @NotNull [] wrapInArray(E element) {
        Class cls = element == null ? Object.class : element.getClass();
        Object[] arr = (Object[])Array.newInstance(cls, 1);
        arr[0] = element;
        return arr;
    }

    @NotNull
    public static String className(Object @NotNull [] array) {
        return array.getClass().getComponentType().getName() + "[]";
    }

    @NotNull
    public static <E> Iterator<E> iterator(E @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Iterators.of(array[0]);
            }
        }
        return new Itr<E>(array, 0, arrayLength);
    }

    @NotNull
    public static <E> Iterator<E> iterator(E @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Iterators.of(array[beginIndex]);
            }
        }
        return new Itr<E>(array, beginIndex, arrayLength);
    }

    @NotNull
    public static <E> Iterator<E> iterator(E @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Iterators.of(array[beginIndex]);
            }
        }
        return new Itr<E>(array, beginIndex, endIndex);
    }

    @NotNull
    public static <E> Spliterator<E> spliterator(E[] array) {
        return Arrays.spliterator(array);
    }

    @NotNull
    public static <E> Stream<E> stream(E @NotNull [] array) {
        return Arrays.stream(array);
    }

    @NotNull
    public static <E> Stream<E> parallelStream(E @NotNull [] array) {
        return (Stream)Arrays.stream(array).parallel();
    }

    public static boolean isEmpty(Object @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(Object @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(Object @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(Object @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static <E> E get(E @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static <E> E getOrNull(E @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? (E)array[index] : null;
    }

    @NotNull
    public static <E> Option<E> getOption(E @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Option.some(array[index]) : Option.none();
    }

    public static <E> void set(E @NotNull [] array, int index, E value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static <E> E @NotNull [] reversed(E @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return array;
            }
            case 1: {
                return (Object[])array.clone();
            }
        }
        Object[] res = array.getClass() == Object[].class ? new Object[length] : (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static <E> Iterator<E> reverseIterator(E @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Iterators.of(array[0]);
            }
        }
        return new ReverseItr<E>(array, length - 1);
    }

    public static void shuffle(Object @NotNull [] array) {
        ObjectArrays.shuffle(array);
    }

    public static void shuffle(Object @NotNull [] array, @NotNull Random random) {
        ObjectArrays.shuffle(array, random);
    }

    public static <E extends Comparable<?>> void sort(E @NotNull [] array) {
        Arrays.sort(array);
    }

    @NotNull
    public static <E> Option<E> find(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return Option.some(e);
        }
        return Option.none();
    }

    public static <E> E first(E @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static <E> E last(E @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(Object @NotNull [] array, Object value) {
        return ObjectArrays.contains(array, value);
    }

    public static boolean containsAll(Object @NotNull [] array, Object @NotNull [] values) {
        return ObjectArrays.containsAll(array, values);
    }

    public static boolean containsAll(Object @NotNull [] array, @NotNull Iterable<?> values) {
        return ObjectArrays.containsAll(array, values);
    }

    public static <E> boolean anyMatch(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean allMatch(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        for (E e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean noneMatch(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] array, Object value) {
        return ObjectArrays.indexOf(array, value);
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] array, Object value, int beginIndex) {
        return ObjectArrays.indexOf(array, value, beginIndex);
    }

    @Contract(pure=true)
    public static <E> int indexWhere(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        return ObjectArrays.indexWhere(array, predicate);
    }

    @Contract(pure=true)
    public static <E> int indexWhere(E @NotNull [] array, @NotNull Predicate<? super E> predicate, int beginIndex) {
        return ObjectArrays.indexWhere(array, predicate, beginIndex);
    }

    @Contract(pure=true)
    public static int lastIndexOf(Object @NotNull [] array, Object value) {
        return ObjectArrays.lastIndexOf(array, value);
    }

    @Contract(pure=true)
    public static int lastIndexOf(Object @NotNull [] array, Object value, int endIndex) {
        return ObjectArrays.lastIndexOf(array, value, endIndex);
    }

    @Contract(pure=true)
    public static <E> int lastIndexWhere(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        return ObjectArrays.lastIndexWhere(array, predicate);
    }

    @Contract(pure=true)
    public static <E> int lastIndexWhere(E @NotNull [] array, @NotNull Predicate<? super E> predicate, int endIndex) {
        return ObjectArrays.lastIndexWhere(array, predicate, endIndex);
    }

    public static <E> E @NotNull [] slice(E @NotNull [] array, int beginIndex, int endIndex) {
        return Arrays.copyOfRange(array, beginIndex, endIndex);
    }

    public static <E> E @NotNull [] drop(E @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (Object[])array.clone();
        }
        int length = array.length;
        if (n >= length) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        return Arrays.copyOfRange(array, n, array.length);
    }

    public static <E> E @NotNull [] dropLast(E @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (Object[])array.clone();
        }
        return GenericArrays.take(array, array.length - n);
    }

    public static <E> E @NotNull [] dropWhile(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        int idx;
        int length = array.length;
        for (idx = 0; idx < length && predicate.test(array[idx]); ++idx) {
        }
        return idx >= length ? GenericArrays.newArrayByOldType(array, 0) : Arrays.copyOfRange(array, idx, length);
    }

    public static <E> E @NotNull [] take(E @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        if (n >= array.length) {
            return (Object[])array.clone();
        }
        return Arrays.copyOfRange(array, 0, n);
    }

    public static <E> E @NotNull [] takeLast(E @NotNull [] array, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        return GenericArrays.drop(array, array.length - n);
    }

    public static <E> E @NotNull [] takeWhile(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        int count;
        int size = array.length;
        if (size == 0) {
            return (Object[])array.clone();
        }
        for (count = 0; count < size && predicate.test(array[count]); ++count) {
        }
        if (count == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        return Arrays.copyOf(array, count);
    }

    public static <E> E @NotNull [] updated(E @NotNull [] array, int index, E newValue) {
        Conditions.checkElementIndex(index, array.length);
        Object[] newValues = (Object[])array.clone();
        newValues[index] = newValue;
        return newValues;
    }

    public static <E> E @NotNull [] filter(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        if (array.length == 0) {
            return (Object[])array.clone();
        }
        E[] tmp = GenericArrays.newArrayByOldType(array, array.length);
        int count = 0;
        for (E e : array) {
            if (!predicate.test(e)) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        if (count == array.length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    public static <E> E @NotNull [] filterNot(E @NotNull [] array, @NotNull Predicate<? super E> predicate) {
        if (array.length == 0) {
            return (Object[])array.clone();
        }
        E[] tmp = GenericArrays.newArrayByOldType(array, array.length);
        int count = 0;
        for (E e : array) {
            if (predicate.test(e)) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        if (count == array.length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    @NotNull
    public static <E> @NotNull E @NotNull [] filterNotNull(E @NotNull [] array) {
        if (array.length == 0) {
            return (Object[])array.clone();
        }
        E[] tmp = GenericArrays.newArrayByOldType(array, array.length);
        int count = 0;
        for (E e : array) {
            if (e == null) continue;
            tmp[count++] = e;
        }
        if (count == 0) {
            return GenericArrays.newArrayByOldType(array, 0);
        }
        if (count == array.length) {
            return tmp;
        }
        return Arrays.copyOf(array, count);
    }

    public static <E, U> U @NotNull [] map(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull Function<? super E, ? extends U> mapper) {
        int length = array.length;
        U[] res = GenericArrays.create(targetType, length);
        for (int i = 0; i < length; ++i) {
            res[i] = mapper.apply(array[i]);
        }
        return res;
    }

    public static <E, U> U @NotNull [] mapIndexed(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull IndexedFunction<? super E, ? extends U> mapper) {
        int length = array.length;
        U[] res = GenericArrays.create(targetType, length);
        for (int i = 0; i < length; ++i) {
            res[i] = mapper.apply(i, array[i]);
        }
        return res;
    }

    @NotNull
    public static <E, U> @NotNull U @NotNull [] mapNotNull(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull Function<? super E, ? extends @Nullable U> mapper) {
        int length = array.length;
        U[] tmp = GenericArrays.create(targetType, length);
        int c = 0;
        for (E e : array) {
            U u = mapper.apply(e);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == length) {
            return tmp;
        }
        return Arrays.copyOf(tmp, c);
    }

    @NotNull
    public static <E, U> @NotNull U @NotNull [] mapIndexedNotNull(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull IndexedFunction<? super E, ? extends @Nullable U> mapper) {
        int length = array.length;
        U[] tmp = GenericArrays.create(targetType, length);
        int c = 0;
        for (int i = 0; i < length; ++i) {
            U u = mapper.apply(i, array[i]);
            if (u == null) continue;
            tmp[c++] = u;
        }
        if (c == length) {
            return tmp;
        }
        return Arrays.copyOf(tmp, c);
    }

    public static <E, U> U @NotNull [] mapMulti(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        U[] emptyArray = GenericArrays.create(targetType, 0);
        if (array.length == 0) {
            return emptyArray;
        }
        ArrayList tmp = new ArrayList();
        Consumer<Object> consumer = tmp::add;
        for (E e : array) {
            mapper.accept(e, consumer);
        }
        return tmp.toArray(emptyArray);
    }

    public static <E, U> U @NotNull [] mapIndexedMulti(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        U[] emptyArray = GenericArrays.create(targetType, 0);
        int length = array.length;
        if (length == 0) {
            return emptyArray;
        }
        ArrayList tmp = new ArrayList();
        Consumer<Object> consumer = tmp::add;
        for (int i = 0; i < length; ++i) {
            mapper.accept(i, array[i], consumer);
        }
        return tmp.toArray(emptyArray);
    }

    public static <E, U> U @NotNull [] flatMap(E @NotNull [] array, @NotNull Class<U> targetType, @NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        U[] emptyArray = GenericArrays.create(targetType, 0);
        if (array.length == 0) {
            return emptyArray;
        }
        ArrayList<U> tmp = new ArrayList<U>();
        for (E e : array) {
            for (U u : mapper.apply(e)) {
                tmp.add(u);
            }
        }
        return tmp.toArray(emptyArray);
    }

    public static <E, U> Tuple2<E, U> @NotNull [] zip(E @NotNull [] array, U @NotNull [] other) {
        int length = Integer.min(array.length, other.length);
        Tuple2[] res = new Tuple2[length];
        for (int i = 0; i < length; ++i) {
            res[i] = Tuple.of(array[i], other[i]);
        }
        return res;
    }

    public static <E, U> Tuple2<E, U> @NotNull [] zip(E @NotNull [] array, Iterable<? extends U> other) {
        int count;
        int length = array.length;
        Tuple2[] tmp = new Tuple2[length];
        if (length == 0) {
            return tmp;
        }
        Iterator<U> it = other.iterator();
        for (count = 0; count < length && it.hasNext(); ++count) {
            tmp[count] = Tuple.of(array[count], it.next());
        }
        return count == length ? tmp : Arrays.copyOf(tmp, count);
    }

    public static <E> E @NotNull [] @NotNull [] chunked(E @NotNull [] array, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        int arrayLength = array.length;
        if (arrayLength == 0) {
            return (Object[][])Array.newInstance(array.getClass(), 0);
        }
        int x = arrayLength / size;
        int r = arrayLength % size;
        Object[][] res = (Object[][])Array.newInstance(array.getClass(), r == 0 ? x : x + 1);
        for (int i = 0; i < x; ++i) {
            res[i] = Arrays.copyOfRange(array, i * size, (i + 1) * size);
        }
        if (r != 0) {
            res[x] = Arrays.copyOfRange(array, x * size, x * size + r);
        }
        return res;
    }

    public static <E> E @NotNull [] @NotNull [] windowed(E @NotNull [] array, int size) {
        return GenericArrays.windowed(array, size, 1, false);
    }

    public static <E> E @NotNull [] @NotNull [] windowed(E @NotNull [] array, int size, int step) {
        return GenericArrays.windowed(array, size, step, false);
    }

    public static <E> E @NotNull [] @NotNull [] windowed(E @NotNull [] array, int size, int step, boolean partialWindows) {
        int windowSize;
        int arrayLength = array.length;
        if (size <= 0 || step <= 0) {
            if (size == step) {
                throw new IllegalArgumentException("size " + size + " must be greater than zero.");
            }
            throw new IllegalArgumentException("Both size " + size + " and step " + step + " must be greater than zero.");
        }
        int resultCapacity = arrayLength / step + (arrayLength % step == 0 ? 0 : 1);
        Object[][] ans = (Object[][])Array.newInstance(array.getClass(), resultCapacity);
        int ansi = 0;
        for (int index = 0; index < arrayLength && ((windowSize = Integer.min(size, arrayLength - index)) >= size || partialWindows); index += step) {
            ans[ansi++] = Arrays.copyOfRange(array, index, windowSize + index);
        }
        return (Object[][])Arrays.copyOf(ans, ansi);
    }

    @Contract(pure=true)
    public static <E extends Comparable<E>> E max(E @NotNull [] array) {
        return (E)((Comparable)ObjectArrays.max(array));
    }

    @Contract(pure=true)
    public static <E> E max(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        int length = array.length;
        E e = array[0];
        for (int i = 1; i < length; ++i) {
            E v = array[i];
            if (comparator.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static <E extends Comparable<E>> E maxOrNull(E @NotNull [] array) {
        return (E)((Comparable)ObjectArrays.maxOrNull(array));
    }

    @Contract(pure=true)
    @Nullable
    public static <E> E maxOrNull(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        int length = array.length;
        if (length == 0) {
            return null;
        }
        E e = array[0];
        for (int i = 1; i < length; ++i) {
            E v = array[i];
            if (comparator.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Comparable<E>> Option<E> maxOption(E @NotNull [] array) {
        if (array.length == 0) {
            return Option.none();
        }
        return Option.some((Comparable)ObjectArrays.max(array));
    }

    @Contract(pure=true)
    @NotNull
    public static <E> Option<E> maxOption(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        if (array.length == 0) {
            return Option.none();
        }
        return Option.some(GenericArrays.max(array, comparator));
    }

    @Contract(pure=true)
    public static <E extends Comparable<E>> E min(E @NotNull [] array) {
        return (E)((Comparable)ObjectArrays.min(array));
    }

    @Contract(pure=true)
    public static <E> E min(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        int length = array.length;
        E e = array[0];
        for (int i = 1; i < length; ++i) {
            E v = array[i];
            if (comparator.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static <E extends Comparable<E>> E minOrNull(E @NotNull [] array) {
        return (E)((Comparable)ObjectArrays.minOrNull(array));
    }

    @Contract(pure=true)
    @Nullable
    public static <E> E minOrNull(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        int length = array.length;
        if (length == 0) {
            return null;
        }
        E e = array[0];
        for (int i = 1; i < length; ++i) {
            E v = array[i];
            if (comparator.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Comparable<E>> Option<E> minOption(E @NotNull [] array) {
        if (array.length == 0) {
            return Option.none();
        }
        return Option.some((Comparable)ObjectArrays.min(array));
    }

    @Contract(pure=true)
    @NotNull
    public static <E> Option<E> minOption(E @NotNull [] array, @NotNull Comparator<? super E> comparator) {
        if (array.length == 0) {
            return Option.none();
        }
        return Option.some(GenericArrays.min(array, comparator));
    }

    @Contract(pure=true)
    public static <E> E fold(E @NotNull [] array, E zero, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static <E, U> U foldLeft(E @NotNull [] array, U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
        for (E e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <E, U> U foldRight(E @NotNull [] array, U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <E> E reduce(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> Option<E> reduceOption(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return GenericArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static <E> E reduceLeft(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        E e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.apply(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static <E> E reduceLeftOrNull(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return array.length != 0 ? (E)GenericArrays.reduceLeft(array, op) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> Option<E> reduceLeftOption(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return array.length != 0 ? Option.some(GenericArrays.reduceLeft(array, op)) : Option.none();
    }

    @Contract(pure=true)
    public static <E> E reduceRight(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        E e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.apply(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static <E> E reduceRightOrNull(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return array.length != 0 ? (E)GenericArrays.reduceRight(array, op) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static <E> Option<E> reduceRightOption(E @NotNull [] array, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return array.length != 0 ? Option.some(GenericArrays.reduceRight(array, op)) : Option.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer) {
        return ObjectArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return ObjectArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(Object @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return ObjectArrays.joinTo(array, buffer, separator, prefix, postfix);
    }

    @NotNull
    public static <E, A extends Appendable> A joinTo(E @NotNull [] array, @NotNull A buffer, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <E, A extends Appendable> A joinTo(E @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <E, A extends Appendable> A joinTo(E @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, buffer, separator, prefix, postfix, transform);
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array) {
        return ObjectArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(Object @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static <E> String joinToString(E @NotNull [] array, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo((Object[])array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static <E> String joinToString(E @NotNull [] array, CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static <E> String joinToString(E @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return ObjectArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static <E> E[] newArrayByOldType(E @NotNull [] old, int newLength) {
        return old.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(old.getClass().getComponentType(), newLength);
    }

    private static final class Factory<E>
    implements CollectionFactory<E, ArrayList<E>, E[]> {
        private final E[] empty;

        Factory(@NotNull Class<E> elementType) {
            this.empty = (Object[])Array.newInstance(elementType, 0);
        }

        @Override
        public E[] empty() {
            return this.empty;
        }

        @Override
        public ArrayList<E> newBuilder() {
            return new ArrayList();
        }

        @Override
        public void addToBuilder(@NotNull ArrayList<E> buffer, E value) {
            buffer.add(value);
        }

        @Override
        public ArrayList<E> mergeBuilder(@NotNull ArrayList<E> builder1, @NotNull ArrayList<E> builder2) {
            builder1.addAll(builder2);
            return builder1;
        }

        @Override
        public E[] build(@NotNull ArrayList<E> buffer) {
            return buffer.toArray(this.empty);
        }
    }

    private static final class Itr<E>
    extends AbstractIterator<E> {
        private final E @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(E @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public E next() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr<E>
    extends AbstractIterator<E> {
        private final E @NotNull [] array;
        private int index;

        ReverseItr(E @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(E @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public E next() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

