/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import kala.Conditions;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanBinaryOperator;
import kala.function.BooleanFunction;
import kala.function.BooleanObjBiFunction;
import kala.function.BooleanPredicate;
import kala.function.ObjBooleanBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BooleanArrays {
    public static final boolean[] EMPTY = new boolean[0];
    private static final IntFunction<boolean[]> GENERATOR = boolean[]::new;

    private BooleanArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<boolean[]> generator() {
        return GENERATOR;
    }

    public static boolean @NotNull [] create(int length) {
        return new boolean[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static boolean @NotNull [] of(boolean ... values) {
        return values;
    }

    public static boolean @NotNull [] from(boolean @NotNull [] values) {
        return (boolean[])values.clone();
    }

    public static boolean @NotNull [] from(@NotNull BooleanTraversable values) {
        return values.toArray();
    }

    public static boolean @NotNull [] from(@NotNull BooleanIterator it) {
        return it.toArray();
    }

    @NotNull
    public static String className(boolean @NotNull [] array) {
        return "boolean[]";
    }

    @NotNull
    public static BooleanIterator iterator(boolean @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return BooleanIterator.empty();
            }
            case 1: {
                return BooleanIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static BooleanIterator iterator(boolean @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return BooleanIterator.empty();
            }
            case 1: {
                return BooleanIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static BooleanIterator iterator(boolean @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return BooleanIterator.empty();
            }
            case 1: {
                return BooleanIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    public static boolean isEmpty(boolean @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(boolean @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(boolean @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(boolean @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static boolean get(boolean @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Boolean getOrNull(boolean @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Boolean.valueOf(array[index]) : null;
    }

    @NotNull
    public static BooleanOption getOption(boolean @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? BooleanOption.some(array[index]) : BooleanOption.none();
    }

    public static void set(boolean @NotNull [] array, int index, boolean value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static boolean @NotNull [] reversed(boolean @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        boolean[] res = new boolean[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static BooleanIterator reverseIterator(boolean @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return BooleanIterator.empty();
            }
            case 1: {
                return BooleanIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(boolean @NotNull [] array) {
        BooleanArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(boolean @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            boolean tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(boolean @NotNull [] array) {
        if (array.length != 0) {
            BooleanArrays.sort(array, 0, array.length);
        }
    }

    public static void sort(boolean @NotNull [] array, int beginIndex, int endIndex) {
        int i;
        Conditions.checkPositionIndices(beginIndex, endIndex, array.length);
        int trueCount = 0;
        for (i = beginIndex; i < endIndex; ++i) {
            if (!array[i]) continue;
            ++trueCount;
        }
        int falseCount = endIndex - beginIndex - trueCount;
        if (trueCount == 0 || falseCount == 0) {
            return;
        }
        for (i = beginIndex; i < falseCount; ++i) {
            array[i] = false;
        }
        for (i = beginIndex + falseCount; i < endIndex; ++i) {
            array[i] = true;
        }
    }

    @NotNull
    public static BooleanOption find(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        for (boolean e : array) {
            if (!predicate.test(e)) continue;
            return BooleanOption.some(e);
        }
        return BooleanOption.none();
    }

    public static boolean first(boolean @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static boolean last(boolean @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(boolean @NotNull [] array, boolean value) {
        for (boolean o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(boolean @NotNull [] array, boolean @NotNull [] values) {
        for (boolean value : values) {
            if (BooleanArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(boolean @NotNull [] array, @NotNull BooleanTraversable values) {
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            boolean value = it.nextBoolean();
            if (BooleanArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        for (boolean e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        for (boolean e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        for (boolean e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(boolean @NotNull [] array, boolean value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(boolean @NotNull [] array, boolean value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(boolean @NotNull [] array, @NotNull BooleanPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(boolean @NotNull [] array, boolean value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(boolean @NotNull [] array, boolean value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(boolean @NotNull [] array, @NotNull BooleanPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(boolean @NotNull [] array, @NotNull BooleanPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean max(boolean @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        for (boolean e : array) {
            if (!e) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @Nullable
    public static Boolean maxOrNull(boolean @NotNull [] array) {
        return array.length != 0 ? Boolean.valueOf(BooleanArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanOption maxOption(boolean @NotNull [] array) {
        return array.length != 0 ? BooleanOption.some(BooleanArrays.max(array)) : BooleanOption.none();
    }

    @Contract(pure=true)
    public static boolean min(boolean @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        for (boolean e : array) {
            if (e) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @Nullable
    public static Boolean minOrNull(boolean @NotNull [] array) {
        return array.length != 0 ? Boolean.valueOf(BooleanArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanOption minOption(boolean @NotNull [] array) {
        return array.length != 0 ? BooleanOption.some(BooleanArrays.min(array)) : BooleanOption.none();
    }

    @Contract(pure=true)
    public static boolean fold(boolean @NotNull [] array, boolean zero, @NotNull BooleanBinaryOperator op) {
        return BooleanArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static boolean foldLeft(boolean @NotNull [] array, boolean zero, @NotNull BooleanBinaryOperator op) {
        for (boolean e : array) {
            zero = op.applyAsBoolean(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(boolean @NotNull [] array, U zero, @NotNull ObjBooleanBiFunction<U, U> op) {
        for (boolean e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static boolean foldRight(boolean @NotNull [] array, boolean zero, @NotNull BooleanBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsBoolean(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(boolean @NotNull [] array, U zero, @NotNull BooleanObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static boolean reduce(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return BooleanArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanOption reduceOption(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return BooleanArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static boolean reduceLeft(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        boolean e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsBoolean(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Boolean reduceLeftOrNull(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return array.length != 0 ? Boolean.valueOf(BooleanArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanOption reduceLeftOption(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return array.length != 0 ? BooleanOption.some(BooleanArrays.reduceLeft(array, op)) : BooleanOption.none();
    }

    @Contract(pure=true)
    public static boolean reduceRight(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        boolean e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsBoolean(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Boolean reduceRightOrNull(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return array.length != 0 ? Boolean.valueOf(BooleanArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static BooleanOption reduceRightOption(boolean @NotNull [] array, @NotNull BooleanBinaryOperator op) {
        return array.length != 0 ? BooleanOption.some(BooleanArrays.reduceRight(array, op)) : BooleanOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer) {
        return BooleanArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return BooleanArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer, @NotNull BooleanFunction<? extends CharSequence> transform) {
        return BooleanArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull BooleanFunction<? extends CharSequence> transform) {
        return BooleanArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(boolean @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BooleanFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array) {
        return BooleanArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array, CharSequence separator) {
        return BooleanArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return BooleanArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array, @NotNull BooleanFunction<? extends CharSequence> transform) {
        return BooleanArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array, CharSequence separator, @NotNull BooleanFunction<? extends CharSequence> transform) {
        return BooleanArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(boolean @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull BooleanFunction<? extends CharSequence> transform) {
        return BooleanArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractBooleanIterator {
        private final boolean @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(boolean @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public boolean nextBoolean() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractBooleanIterator {
        private final boolean @NotNull [] array;
        private int index;

        ReverseItr(boolean @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(boolean @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public boolean nextBoolean() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

