/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.Growable;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteGrowable;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.control.primitive.ByteOption;
import kala.function.ByteBinaryOperator;
import kala.function.ByteConsumer;
import kala.function.ByteFunction;
import kala.function.ByteObjBiFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import kala.function.CheckedByteConsumer;
import kala.function.ObjByteBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteTraversable
extends PrimitiveTraversable<Byte> {
    @Override
    @NotNull
    public ByteIterator iterator();

    default public byte elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        ByteIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextByte();
        }
        if (it.hasNext()) {
            return it.nextByte();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public ByteOption find(@NotNull BytePredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(byte value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(byte @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull ByteTraversable values) {
        ByteIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextByte())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull ByteTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull BytePredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull BytePredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull BytePredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G filterTo(@NotNull G destination, @NotNull BytePredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G filterNotTo(@NotNull G destination, @NotNull BytePredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends ByteGrowable> G mapTo(@NotNull G destination, @NotNull ByteUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull ByteFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull BytePredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public byte max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Byte maxOrNull() {
        return this.isNotEmpty() ? Byte.valueOf(this.max()) : null;
    }

    @NotNull
    default public ByteOption maxOption() {
        return this.knownSize() == 0 ? ByteOption.none() : this.iterator().maxOption();
    }

    default public byte min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Byte minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public ByteOption minOption() {
        return this.knownSize() == 0 ? ByteOption.none() : this.iterator().minOption();
    }

    default public byte fold(byte zero, @NotNull ByteBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public byte foldLeft(byte zero, @NotNull ByteBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjByteBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public byte foldRight(byte zero, @NotNull ByteBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull ByteObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public byte reduce(@NotNull ByteBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Byte reduceOrNull(@NotNull ByteBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public ByteOption reduceOption(@NotNull ByteBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public byte reduceLeft(@NotNull ByteBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Byte reduceLeftOrNull(@NotNull ByteBinaryOperator op) {
        return this.isNotEmpty() ? Byte.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public ByteOption reduceLeftOption(@NotNull ByteBinaryOperator op) {
        return this.isNotEmpty() ? ByteOption.some(this.reduceLeft(op)) : ByteOption.none();
    }

    default public byte reduceRight(@NotNull ByteBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Byte reduceRightOrNull(@NotNull ByteBinaryOperator op) {
        return this.isNotEmpty() ? Byte.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public ByteOption reduceRightOption(@NotNull ByteBinaryOperator op) {
        return this.isNotEmpty() ? ByteOption.some(this.reduceRight(op)) : ByteOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(byte @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(byte @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(byte @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, byte @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, byte @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, byte @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        ByteIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextByte();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextByte();
        }
        return idx - destPos;
    }

    default public byte @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return ByteArrays.EMPTY;
        }
        if (s > 0) {
            byte[] arr = new byte[s];
            int i = 0;
            ByteIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                byte t = iterator.nextByte();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull ByteConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedByteConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedByteConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull BytePredicate action) {
        Objects.requireNonNull(action);
        ByteIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextByte())) {
        }
    }
}

