/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import org.jetbrains.annotations.NotNull;

public interface IntCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Integer, Builder, R> {
    public static <Builder, R> IntCollectionFactory<Builder, R> narrow(IntCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, int var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Integer value) {
        this.addToBuilder(builder, (int)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull IntTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull IntIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextInt());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, int @NotNull [] values) {
        Objects.requireNonNull(values);
        for (int value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, int value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, IntSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsInt());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Integer value) {
        return this.fill(n, (int)value);
    }

    default public R from(int @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull IntTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull IntIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> IntCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final IntCollectionFactory self = this;
        return new IntCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, int value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

