/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.FloatComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FloatComparators {
    FloatComparators() {
    }

    static final class ReverseOrderNullComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(float f1, float f2) {
            return Float.compare(f2, f1);
        }

        @Override
        public int compare(Float f1, Float f2) {
            if (f1 == null) {
                return f2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (f2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return f2.compareTo(f1);
        }

        @Override
        @NotNull
        public FloatComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public FloatComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public FloatComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(float f1, float b2) {
            return Float.compare(f1, b2);
        }

        @Override
        public int compare(Float f1, Float b2) {
            if (f1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return f1.compareTo(b2);
        }

        @Override
        @NotNull
        public FloatComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public FloatComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public FloatComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements FloatComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final FloatComparator real;

        NullComparator(boolean nullFirst, @NotNull FloatComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(float f1, float b2) {
            return this.real.compare(f1, b2);
        }

        @Override
        public int compare(@Nullable Float f1, @Nullable Float b2) {
            if (f1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(f1, b2);
        }

        @Override
        @NotNull
        public FloatComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public FloatComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public FloatComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements FloatComparator
    {
        INSTANCE;


        @Override
        public final int compare(float f1, float b2) {
            return Float.compare(b2, f1);
        }

        @Override
        @NotNull
        public final FloatComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final FloatComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final FloatComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements FloatComparator
    {
        INSTANCE;


        @Override
        public final int compare(float f1, float b2) {
            return Float.compare(f1, b2);
        }

        @Override
        @NotNull
        public final FloatComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final FloatComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final FloatComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

