/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.function.BiFunction;
import kala.control.Try;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedBiFunction<T, U, R, Ex extends Throwable>
extends BiFunction<T, U, R> {
    @Contract(value="_ -> param1", pure=true)
    public static <T, U, R, Ex extends Throwable> CheckedBiFunction<T, U, R, Ex> of(CheckedBiFunction<? super T, ? super U, ? extends R, ? extends Ex> function) {
        return function;
    }

    public R applyChecked(T var1, U var2) throws Ex;

    @Override
    default public R apply(T t, U u) {
        try {
            return this.applyChecked(t, u);
        }
        catch (Throwable e) {
            return Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<R> tryApply(T t, U u) {
        try {
            return Try.success(this.applyChecked(t, u));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }
}

