/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import kala.control.Try;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedIndexedFunction<T, R, Ex extends Throwable>
extends IndexedFunction<T, R> {
    @Contract(value="_ -> param1", pure=true)
    public static <T, R, Ex extends Throwable> CheckedIndexedFunction<T, R, Ex> of(CheckedIndexedFunction<? super T, ? extends R, ? extends Ex> consumer) {
        return consumer;
    }

    public R applyChecked(int var1, T var2) throws Ex;

    @Override
    default public R apply(int index, T t) {
        try {
            return this.applyChecked(index, t);
        }
        catch (Throwable ex) {
            return Try.sneakyThrow(ex);
        }
    }

    @Deprecated
    @NotNull
    default public Try<R> tryApply(int index, T t) {
        try {
            return Try.success(this.applyChecked(index, t));
        }
        catch (Throwable ex) {
            return Try.failure(ex);
        }
    }
}

