/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import kala.function.Memoized;
import kala.function.MemoizedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Functions {
    private Functions() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T, R> Function<T, R> of(Function<? super T, ? extends R> function) {
        return function;
    }

    @NotNull
    public static <T> Function<T, T> identity() {
        return Identity.INSTANCE;
    }

    @NotNull
    public static <T, R> Function<T, R> memoized(@NotNull Function<? super T, ? extends R> function) {
        return Functions.memoized(function, false);
    }

    @NotNull
    public static <T, R> Function<T, R> memoized(@NotNull Function<? super T, ? extends R> function, boolean sync) {
        Objects.requireNonNull(function);
        if (function instanceof Memoized) {
            return function;
        }
        return new MemoizedFunction<T, R>(function, sync ? Collections.synchronizedMap(new HashMap()) : new HashMap());
    }

    @NotNull
    public static <T, R> Function<T, R> weakMemoized(@NotNull Function<? super T, ? extends R> function) {
        return Functions.weakMemoized(function, false);
    }

    @NotNull
    public static <T, R> Function<T, R> weakMemoized(@NotNull Function<? super T, ? extends R> function, boolean sync) {
        Objects.requireNonNull(function);
        return new MemoizedFunction<T, R>(function, sync ? Collections.synchronizedMap(new WeakHashMap()) : new WeakHashMap());
    }

    private static enum Identity implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public Object apply(Object o) {
            return o;
        }

        @Override
        @NotNull
        public <V> Function<V, Object> compose(@NotNull Function<? super V, ?> before) {
            return before;
        }

        @Override
        @NotNull
        public <V> Function<Object, V> andThen(@NotNull Function<? super Object, ? extends V> after) {
            return after;
        }

        public String toString() {
            return "Functions.Identity";
        }
    }
}

