/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface Hasher<T>
extends BiPredicate<T, T> {
    public static final Hasher<?> DEFAULT = new Default();
    public static final Hasher<?> OPTIMIZED = new Optimized();
    public static final Hasher<?> IDENTITY = new Identity();

    public static <T> Hasher<T> narrow(Hasher<? super T> hasher) {
        return hasher;
    }

    public static <T> Hasher<T> defaultHasher() {
        return DEFAULT;
    }

    public static <T> Hasher<T> optimizedHasher() {
        return OPTIMIZED;
    }

    public static <T> Hasher<T> identityHasher() {
        return IDENTITY;
    }

    public int hash(T var1);

    default public boolean equals(T t1, T t2) {
        return Objects.equals(t1, t2);
    }

    @Override
    @Deprecated
    default public boolean test(T t1, T t2) {
        return this.equals(t1, t2);
    }

    public static final class Default<T>
    implements Hasher<T>,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(T obj) {
            return Objects.hashCode(obj);
        }

        private Object readResolve() {
            return DEFAULT;
        }
    }

    public static final class Optimized<T>
    implements Hasher<T>,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(T obj) {
            if (obj == null) {
                return 0;
            }
            int originalHash = obj.hashCode();
            return originalHash ^ originalHash >>> 16;
        }

        private Object readResolve() {
            return OPTIMIZED;
        }
    }

    public static final class Identity<T>
    implements Hasher<T>,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(T obj) {
            return System.identityHashCode(obj);
        }

        @Override
        public boolean equals(T t1, T t2) {
            return t1 == t2;
        }

        private Object readResolve() {
            return IDENTITY;
        }
    }
}

