/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import kala.function.Memoized;
import kala.internal.InternalIdentifyObject;
import org.jetbrains.annotations.NotNull;

final class MemoizedFunction<T, R>
implements Function<T, R>,
Memoized,
Serializable {
    private static final long serialVersionUID = -904511663627169337L;
    private static final Object NULL_HOLE = new InternalIdentifyObject();
    @NotNull
    private final Function<? super T, ? extends R> function;
    @NotNull
    private final Map<T, Object> cache;

    MemoizedFunction(@NotNull Function<? super T, ? extends R> function, @NotNull Map<T, Object> cache) {
        this.function = function;
        this.cache = cache;
    }

    @Override
    public R apply(T t) {
        Object res = this.cache.computeIfAbsent(t, key -> {
            R v = this.function.apply(key);
            return v != null ? v : NULL_HOLE;
        });
        return (R)(res != NULL_HOLE ? res : null);
    }

    public String toString() {
        return "MemoizedFunction[function=" + this.function + ", cache=" + this.cache + ']';
    }
}

