/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

public final class BooleanUtils {
    public static final int BITS_PRE_VALUE = 32;
    public static final int FULL_BITS = -1;

    private BooleanUtils() {
    }

    public static boolean get(int bits, int position) {
        return (bits >> position & 1) != 0;
    }

    public static int set(int bits, int position, boolean newValue) {
        if (newValue) {
            return bits | 1 << position;
        }
        return bits & -(1 << position);
    }

    public static boolean get(int[] bitsArray, int index) {
        return BooleanUtils.get(bitsArray[index / 32], index % 32);
    }

    public static void set(int[] bitsArray, int index, boolean newValue) {
        int i = index / 32;
        bitsArray[i] = BooleanUtils.set(bitsArray[i], index % 32, newValue);
    }
}

