/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.util.Arrays;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalByteArrayBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private byte[] elements = ByteArrays.EMPTY;
    private int size = 0;

    private void grow() {
        byte[] newArray;
        int oldCapacity = this.elements.length;
        if (oldCapacity == 0) {
            newArray = new byte[Math.max(16, this.size + 1)];
        } else {
            int newCapacity = Math.max(Math.max(oldCapacity, this.size + 1), oldCapacity + (oldCapacity >> 1));
            newArray = new byte[newCapacity];
        }
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    public int size() {
        return this.size;
    }

    public byte get(int idx) {
        return this.elements[idx];
    }

    public void set(int idx, byte newValue) {
        this.elements[idx] = newValue;
    }

    public void append(byte value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    public byte[] toArray() {
        return this.elements.length == this.size ? this.elements : Arrays.copyOf(this.elements, this.size);
    }

    public ByteIterator iterator() {
        return ByteArrays.iterator(this.elements, 0, this.size);
    }
}

