/*
 * Decompiled with CFR 0.152.
 */
package kala.internal;

import java.util.Arrays;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class InternalDoubleArrayBuilder {
    private static final int DEFAULT_CAPACITY = 16;
    private double[] elements = DoubleArrays.EMPTY;
    private int size = 0;

    private void grow() {
        double[] newArray;
        int oldCapacity = this.elements.length;
        if (oldCapacity == 0) {
            newArray = new double[Math.max(16, this.size + 1)];
        } else {
            int newCapacity = Math.max(Math.max(oldCapacity, this.size + 1), oldCapacity + (oldCapacity >> 1));
            newArray = new double[newCapacity];
        }
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    public int size() {
        return this.size;
    }

    public double get(int idx) {
        return this.elements[idx];
    }

    public void set(int idx, double newValue) {
        this.elements[idx] = newValue;
    }

    public void append(double value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    public double[] toArray() {
        return this.elements.length == this.size ? this.elements : Arrays.copyOf(this.elements, this.size);
    }

    public DoubleIterator iterator() {
        return DoubleArrays.iterator(this.elements, 0, this.size);
    }
}

