/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.Tuple1;
import kala.tuple.Tuple3;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Tuple2<T1, T2>
extends HList<T1, Tuple1<T2>>
implements Serializable,
Map.Entry<T1, T2> {
    private static final long serialVersionUID = -1620386824894229867L;
    public final T1 _1;
    public final T2 _2;

    public Tuple2(T1 t1, T2 t2) {
        this._1 = t1;
        this._2 = t2;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2> Tuple2<T1, T2> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends Unit>> tuple) {
        return (Tuple2)tuple;
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)this._1;
            }
            case 1: {
                return (U)this._2;
            }
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this._1;
        arr[1] = this._2;
        return arr;
    }

    public T1 component1() {
        return this._1;
    }

    public T2 component2() {
        return this._2;
    }

    @Override
    public T1 head() {
        return this._1;
    }

    @Override
    @NotNull
    public Tuple1<T2> tail() {
        return Tuple2.of(this._2);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple3<H, T1, T2> cons(H head) {
        return new Tuple3<H, T1, T2>(head, this._1, this._2);
    }

    @Override
    public T1 getKey() {
        return this._1;
    }

    @Override
    public T2 getValue() {
        return this._2;
    }

    @Override
    @Deprecated
    @Contract(value="_ -> fail")
    public T2 setValue(T2 value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Tuple2.setValue");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple2) {
            Tuple2 other = (Tuple2)o;
            return Objects.equals(this._1, other._1) && Objects.equals(this._2, other._2);
        }
        if (o instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)o;
            return Objects.equals(this._1, other.getKey()) && Objects.equals(this._2, other.getValue());
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 2 && Objects.equals(this._1, other.elementAt(0)) && Objects.equals(this._2, other.elementAt(1));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this._1) ^ Objects.hashCode(this._2);
    }

    public String toString() {
        return "(" + this._1 + ", " + this._2 + ")";
    }
}

