/*
 * Decompiled with CFR 0.152.
 */
package kala.tuple;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.tuple.AnyTuple;
import kala.tuple.HList;
import kala.tuple.Tuple2;
import kala.tuple.Tuple4;
import kala.tuple.Unit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Tuple3<T1, T2, T3>
extends HList<T1, Tuple2<T2, T3>>
implements Serializable {
    private static final long serialVersionUID = 972431264501348711L;
    public final T1 _1;
    public final T2 _2;
    public final T3 _3;

    public Tuple3(T1 t1, T2 t2, T3 t3) {
        this._1 = t1;
        this._2 = t2;
        this._3 = t3;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T1, T2, T3> Tuple3<T1, T2, T3> narrow(HList<? extends T1, ? extends HList<? extends T2, ? extends HList<? extends T3, ? extends Unit>>> tuple) {
        return (Tuple3)tuple;
    }

    @Override
    public int arity() {
        return 3;
    }

    @Override
    public <U> U elementAt(int index) {
        switch (index) {
            case 0: {
                return (U)this._1;
            }
            case 1: {
                return (U)this._2;
            }
            case 2: {
                return (U)this._3;
            }
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    @Override
    public <U> U @NotNull [] toArray(@NotNull IntFunction<U[]> generator) {
        U[] arr = generator.apply(this.arity());
        arr[0] = this._1;
        arr[1] = this._2;
        arr[2] = this._3;
        return arr;
    }

    public T1 component1() {
        return this._1;
    }

    public T2 component2() {
        return this._2;
    }

    public T3 component3() {
        return this._3;
    }

    @Override
    public T1 head() {
        return this._1;
    }

    @Override
    @NotNull
    public Tuple2<T2, T3> tail() {
        return Tuple3.of(this._2, this._3);
    }

    @Contract(value="_ -> new")
    @NotNull
    public <H> Tuple4<H, T1, T2, T3> cons(H head) {
        return new Tuple4<H, T1, T2, T3>(head, this._1, this._2, this._3);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Tuple3) {
            Tuple3 other = (Tuple3)o;
            return Objects.equals(this._1, other._1) && Objects.equals(this._2, other._2) && Objects.equals(this._3, other._3);
        }
        if (o instanceof AnyTuple) {
            AnyTuple other = (AnyTuple)o;
            return other.arity() == 3 && Objects.equals(this._1, other.elementAt(0)) && Objects.equals(this._2, other.elementAt(1)) && Objects.equals(this._3, other.elementAt(2));
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + Objects.hashCode(this._1);
        hash = 31 * hash + Objects.hashCode(this._2);
        hash = 31 * hash + Objects.hashCode(this._3);
        return hash + 427632945;
    }

    public String toString() {
        return "(" + this._1 + ", " + this._2 + ", " + this._3 + ")";
    }
}

