/*
 * Decompiled with CFR 0.152.
 */
package kala.value;

import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kala.value.AtomicVar;
import kala.value.DelegateMutableValue;
import kala.value.MutableAnyValue;
import kala.value.TransientVar;
import kala.value.Value;
import kala.value.Var;
import kala.value.VolatileVar;
import org.jetbrains.annotations.NotNull;

public interface MutableValue<T>
extends MutableAnyValue<T>,
Value<T>,
Consumer<T> {
    @NotNull
    public static <T> MutableValue<T> create() {
        return new Var();
    }

    @NotNull
    public static <T> MutableValue<T> create(T initialValue) {
        return new Var<T>(initialValue);
    }

    @NotNull
    public static <T> MutableValue<T> createTransient() {
        return new TransientVar();
    }

    @NotNull
    public static <T> MutableValue<T> createTransient(T initialValue) {
        return new TransientVar<T>(initialValue);
    }

    @NotNull
    public static <T> MutableValue<T> createVolatile() {
        return new VolatileVar();
    }

    @NotNull
    public static <T> MutableValue<T> createVolatile(T initialValue) {
        return new VolatileVar<T>(initialValue);
    }

    @NotNull
    public static <T> MutableValue<T> createAtomic() {
        return new AtomicVar();
    }

    @NotNull
    public static <T> MutableValue<T> createAtomic(T initialValue) {
        return new AtomicVar<T>(initialValue);
    }

    @NotNull
    public static <T> MutableValue<T> by(@NotNull Supplier<? extends T> getter, @NotNull Consumer<? super T> setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableValue<T>(getter, setter);
    }

    public void set(T var1);

    @Override
    default public void setValue(T value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(T t) {
        this.set(t);
    }

    @NotNull
    default public MutableValue<T> withGetter(@NotNull Supplier<? extends T> newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableValue<T>(newGetter, this);
    }

    @NotNull
    default public MutableValue<T> withSetter(@NotNull Consumer<? super T> newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableValue<T>(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableValue<T> asMutable(@NotNull Consumer<? super T> setter) {
        return this.withSetter(setter);
    }

    default public T getAndSet(T newValue) {
        Object oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(T expectedValue, T newValue) {
        if (Objects.equals(this.get(), expectedValue)) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull UnaryOperator<T> updateFunction) {
        this.set(updateFunction.apply(this.get()));
    }

    default public T getAndUpdate(@NotNull UnaryOperator<T> updateFunction) {
        Object v = this.get();
        this.set(updateFunction.apply(v));
        return v;
    }

    default public T updateAndGet(@NotNull UnaryOperator<T> updateFunction) {
        Object v = updateFunction.apply(this.get());
        this.set(v);
        return (T)v;
    }

    default public void accumulate(T t, @NotNull BinaryOperator<T> accumulatorFunction) {
        this.set(accumulatorFunction.apply(this.get(), t));
    }

    default public T getAndAccumulate(T t, @NotNull BinaryOperator<T> accumulatorFunction) {
        Object v = this.get();
        this.set(accumulatorFunction.apply(v, t));
        return v;
    }

    default public T accumulateAndGet(T t, @NotNull BinaryOperator<T> accumulatorFunction) {
        Object v = accumulatorFunction.apply(this.get(), t);
        this.set(v);
        return (T)v;
    }
}

