/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.function.BooleanFunction;
import kala.function.BooleanUnaryOperator;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractBooleanValue;
import kala.value.primitive.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class LazyBooleanValue
extends AbstractBooleanValue
implements BooleanTraversable,
BooleanValue,
BooleanSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient BooleanSupplier supplier;
    private transient boolean value;

    private LazyBooleanValue(BooleanSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyBooleanValue(boolean value) {
        this.value = value;
    }

    public static LazyBooleanValue of(@NotNull BooleanSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyBooleanValue(supplier);
    }

    public static LazyBooleanValue ofValue(boolean value) {
        return new LazyBooleanValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get() {
        if (this.supplier != null) {
            LazyBooleanValue lazyBooleanValue = this;
            synchronized (lazyBooleanValue) {
                BooleanSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsBoolean();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public boolean getAsBoolean() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyBooleanValue map(@NotNull BooleanUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyBooleanValue.of(() -> mapper.applyAsBoolean(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull BooleanFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public BooleanIterator iterator() {
        return new AbstractBooleanIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public boolean nextBoolean() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyBooleanValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyBooleanValue[" + this.value + "]";
        }
        return "LazyBooleanValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readBoolean();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.get());
    }
}

