/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractIntValue;
import kala.value.primitive.IntValue;
import org.jetbrains.annotations.NotNull;

public class LazyIntValue
extends AbstractIntValue
implements IntTraversable,
IntValue,
IntSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient IntSupplier supplier;
    private transient int value;

    private LazyIntValue(IntSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyIntValue(int value) {
        this.value = value;
    }

    public static LazyIntValue of(@NotNull IntSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyIntValue(supplier);
    }

    public static LazyIntValue ofValue(int value) {
        return new LazyIntValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get() {
        if (this.supplier != null) {
            LazyIntValue lazyIntValue = this;
            synchronized (lazyIntValue) {
                IntSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsInt();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public int getAsInt() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyIntValue map(@NotNull IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyIntValue.of(() -> mapper.applyAsInt(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public IntIterator iterator() {
        return new AbstractIntIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyIntValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyIntValue[" + this.value + "]";
        }
        return "LazyIntValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readInt();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.get());
    }
}

