/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.function.ByteBinaryOperator;
import kala.function.ByteConsumer;
import kala.function.ByteSupplier;
import kala.function.ByteUnaryOperator;
import kala.value.primitive.ByteValue;
import kala.value.primitive.ByteVar;
import kala.value.primitive.DelegateMutableByteValue;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.VolatileByteVar;
import org.jetbrains.annotations.NotNull;

public interface MutableByteValue
extends MutablePrimitiveValue<Byte>,
ByteValue,
ByteConsumer {
    @NotNull
    public static MutableByteValue create() {
        return new ByteVar();
    }

    @NotNull
    public static MutableByteValue create(byte initialValue) {
        return new ByteVar(initialValue);
    }

    @NotNull
    public static MutableByteValue createVolatile() {
        return new VolatileByteVar();
    }

    @NotNull
    public static MutableByteValue createVolatile(byte initialValue) {
        return new VolatileByteVar(initialValue);
    }

    @NotNull
    public static MutableByteValue by(@NotNull ByteSupplier getter, @NotNull ByteConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableByteValue(getter, setter);
    }

    public void set(byte var1);

    @Override
    default public void setValue(@NotNull Byte value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(byte value) {
        this.set(value);
    }

    @NotNull
    default public MutableByteValue withGetter(@NotNull ByteSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableByteValue(newGetter, this);
    }

    @NotNull
    default public MutableByteValue withSetter(@NotNull ByteConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableByteValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableByteValue asMutable(@NotNull ByteConsumer setter) {
        return this.withSetter(setter);
    }

    default public byte getAndSet(byte newValue) {
        byte oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(byte expectedValue, byte newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull ByteUnaryOperator updateFunction) {
        this.set(updateFunction.applyAsByte(this.get()));
    }

    default public byte getAndUpdate(@NotNull ByteUnaryOperator updateFunction) {
        byte v = this.get();
        this.set(updateFunction.applyAsByte(v));
        return v;
    }

    default public byte updateAndGet(@NotNull ByteUnaryOperator updateFunction) {
        byte v = updateFunction.applyAsByte(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(byte t, @NotNull ByteBinaryOperator accumulatorFunction) {
        this.set(accumulatorFunction.applyAsByte(this.get(), t));
    }

    default public byte getAndAccumulate(byte t, @NotNull ByteBinaryOperator accumulatorFunction) {
        byte v = this.get();
        this.set(accumulatorFunction.applyAsByte(v, t));
        return v;
    }

    default public byte accumulateAndGet(byte t, @NotNull ByteBinaryOperator accumulatorFunction) {
        byte v = accumulatorFunction.applyAsByte(this.get(), t);
        this.set(v);
        return v;
    }

    default public void increment() {
        this.set((byte)(this.get() + 1));
    }

    default public void decrement() {
        this.set((byte)(this.get() - 1));
    }

    default public void add(int delta) {
        this.set((byte)(this.get() + delta));
    }

    default public void sub(int delta) {
        this.set((byte)(this.get() - delta));
    }

    default public byte getAndIncrement() {
        byte v = this.get();
        this.set((byte)(v + 1));
        return v;
    }

    default public byte getAndDecrement() {
        byte v = this.get();
        this.set((byte)(v - 1));
        return v;
    }

    default public byte getAndAdd(int delta) {
        byte v = this.get();
        this.set((byte)(this.get() + delta));
        return v;
    }

    default public byte getAndSub(int delta) {
        byte v = this.get();
        this.set((byte)(this.get() - delta));
        return v;
    }

    default public byte incrementAndGet() {
        byte v = (byte)(this.get() + 1);
        this.set(v);
        return v;
    }

    default public byte decrementAndGet() {
        byte v = (byte)(this.get() - 1);
        this.set(v);
        return v;
    }

    default public byte addAndGet(int delta) {
        byte v = (byte)(this.get() + delta);
        this.set(v);
        return v;
    }

    default public byte subAndGet(int delta) {
        byte v = (byte)(this.get() - delta);
        this.set(v);
        return v;
    }
}

