/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.function.ShortBinaryOperator;
import kala.function.ShortConsumer;
import kala.function.ShortSupplier;
import kala.function.ShortUnaryOperator;
import kala.value.primitive.DelegateMutableShortValue;
import kala.value.primitive.MutablePrimitiveValue;
import kala.value.primitive.ShortValue;
import kala.value.primitive.ShortVar;
import kala.value.primitive.VolatileShortVar;
import org.jetbrains.annotations.NotNull;

public interface MutableShortValue
extends MutablePrimitiveValue<Short>,
ShortValue,
ShortConsumer {
    @NotNull
    public static MutableShortValue create() {
        return new ShortVar();
    }

    @NotNull
    public static MutableShortValue create(short initialValue) {
        return new ShortVar(initialValue);
    }

    @NotNull
    public static MutableShortValue createVolatile() {
        return new VolatileShortVar();
    }

    @NotNull
    public static MutableShortValue createVolatile(short initialValue) {
        return new VolatileShortVar(initialValue);
    }

    @NotNull
    public static MutableShortValue by(@NotNull ShortSupplier getter, @NotNull ShortConsumer setter) {
        Objects.requireNonNull(getter);
        Objects.requireNonNull(setter);
        return new DelegateMutableShortValue(getter, setter);
    }

    public void set(short var1);

    @Override
    default public void setValue(@NotNull Short value) {
        this.set(value);
    }

    @Override
    @Deprecated
    default public void accept(short value) {
        this.set(value);
    }

    @NotNull
    default public MutableShortValue withGetter(@NotNull ShortSupplier newGetter) {
        Objects.requireNonNull(newGetter);
        return new DelegateMutableShortValue(newGetter, this);
    }

    @NotNull
    default public MutableShortValue withSetter(@NotNull ShortConsumer newSetter) {
        Objects.requireNonNull(newSetter);
        return new DelegateMutableShortValue(this, newSetter);
    }

    @Override
    @Deprecated
    @NotNull
    default public MutableShortValue asMutable(@NotNull ShortConsumer setter) {
        return this.withSetter(setter);
    }

    default public short getAndSet(short newValue) {
        short oldValue = this.get();
        this.set(newValue);
        return oldValue;
    }

    default public boolean compareAndSet(short expectedValue, short newValue) {
        if (this.get() == expectedValue) {
            this.set(newValue);
            return true;
        }
        return false;
    }

    default public void update(@NotNull ShortUnaryOperator updateFunction) {
        this.set(updateFunction.applyAsShort(this.get()));
    }

    default public short getAndUpdate(@NotNull ShortUnaryOperator updateFunction) {
        short v = this.get();
        this.set(updateFunction.applyAsShort(v));
        return v;
    }

    default public short updateAndGet(@NotNull ShortUnaryOperator updateFunction) {
        short v = updateFunction.applyAsShort(this.get());
        this.set(v);
        return v;
    }

    default public void accumulate(short t, @NotNull ShortBinaryOperator accumulatorFunction) {
        this.set(accumulatorFunction.applyAsShort(this.get(), t));
    }

    default public short getAndAccumulate(short t, @NotNull ShortBinaryOperator accumulatorFunction) {
        short v = this.get();
        this.set(accumulatorFunction.applyAsShort(v, t));
        return v;
    }

    default public short accumulateAndGet(short t, @NotNull ShortBinaryOperator accumulatorFunction) {
        short v = accumulatorFunction.applyAsShort(this.get(), t);
        this.set(v);
        return v;
    }

    default public void increment() {
        this.set((short)(this.get() + 1));
    }

    default public void decrement() {
        this.set((short)(this.get() - 1));
    }

    default public void add(int delta) {
        this.set((short)(this.get() + delta));
    }

    default public void sub(int delta) {
        this.set((short)(this.get() - delta));
    }

    default public short getAndIncrement() {
        short v = this.get();
        this.set((short)(v + 1));
        return v;
    }

    default public short getAndDecrement() {
        short v = this.get();
        this.set((short)(v - 1));
        return v;
    }

    default public short getAndAdd(int delta) {
        short v = this.get();
        this.set((short)(this.get() + delta));
        return v;
    }

    default public short getAndSub(int delta) {
        short v = this.get();
        this.set((short)(this.get() - delta));
        return v;
    }

    default public short incrementAndGet() {
        short v = (short)(this.get() + 1);
        this.set(v);
        return v;
    }

    default public short decrementAndGet() {
        short v = (short)(this.get() - 1);
        this.set(v);
        return v;
    }

    default public short addAndGet(int delta) {
        short v = (short)(this.get() + delta);
        this.set(v);
        return v;
    }

    default public short subAndGet(int delta) {
        short v = (short)(this.get() - delta);
        this.set(v);
        return v;
    }
}

