/*
 * Decompiled with CFR 0.152.
 */
package kala;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class Conditions {
    private static final boolean isAssertionEnabled;

    private Conditions() {
    }

    public static void checkElementIndex(int index, @Range(from=0L, to=0x7FFFFFFFL) int size) throws IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            Conditions.checkElementIndexFailed(index, size);
        }
    }

    @Contract(value="_, _ -> fail")
    private static void checkElementIndexFailed(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size(" + size + ") < 0");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index(" + index + ") < 0");
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException("index(" + index + ") >= size(" + size + ")");
        }
        throw new AssertionError();
    }

    public static void checkPositionIndex(int index, @Range(from=0L, to=0x7FFFFFFFL) int size) throws IndexOutOfBoundsException {
        if (index < 0 || index > size) {
            Conditions.checkPositionIndexFailed(index, size);
        }
    }

    @Contract(value="_, _ -> fail")
    private static void checkPositionIndexFailed(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size(" + size + ") < 0");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index(" + index + ") < 0");
        }
        if (index > size) {
            throw new IndexOutOfBoundsException("index(" + index + ") > size(" + size + ")");
        }
        throw new AssertionError();
    }

    public static void checkPositionIndices(int beginIndex, int endIndex, @Range(from=0L, to=0x7FFFFFFFL) int size) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > size) {
            Conditions.checkPositionIndicesFailed(beginIndex, endIndex, size);
        }
    }

    @Contract(value="_, _, _ -> fail")
    private static void checkPositionIndicesFailed(int beginIndex, int endIndex, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size(" + size + ") < 0");
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        if (beginIndex > size) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + size + ")");
        }
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("endIndex(" + endIndex + ") < 0");
        }
        if (endIndex > size) {
            throw new IndexOutOfBoundsException("endIndex(" + endIndex + ") > size(" + size + ")");
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
        }
        throw new AssertionError((Object)"checkPositionIndicesFailed");
    }

    public static boolean equals(boolean v1, boolean v2) {
        return v1 == v2;
    }

    public static boolean equals(char v1, char v2) {
        return v1 == v2;
    }

    public static boolean equals(byte v1, byte v2) {
        return v1 == v2;
    }

    public static boolean equals(short v1, short v2) {
        return v1 == v2;
    }

    public static boolean equals(int v1, int v2) {
        return v1 == v2;
    }

    public static boolean equals(long v1, long v2) {
        return v1 == v2;
    }

    public static boolean equals(float v1, float v2) {
        return Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean equals(double v1, double v2) {
        return Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean equals(Object v1, boolean v2) {
        return v1 instanceof Boolean && (Boolean)v1 == v2;
    }

    public static boolean equals(Object v1, char v2) {
        return v1 instanceof Character && ((Character)v1).charValue() == v2;
    }

    public static boolean equals(Object v1, byte v2) {
        return v1 instanceof Byte && (Byte)v1 == v2;
    }

    public static boolean equals(Object v1, short v2) {
        return v1 instanceof Short && (Short)v1 == v2;
    }

    public static boolean equals(Object v1, int v2) {
        return v1 instanceof Integer && (Integer)v1 == v2;
    }

    public static boolean equals(Object v1, long v2) {
        return v1 instanceof Long && (Long)v1 == v2;
    }

    public static boolean equals(Object v1, float v2) {
        return v1 instanceof Float && Float.floatToIntBits(((Float)v1).floatValue()) == Float.floatToIntBits(v2);
    }

    public static boolean equals(Object v1, double v2) {
        return v1 instanceof Double && Double.doubleToLongBits((Double)v1) == Double.doubleToLongBits(v2);
    }

    public static boolean equals(boolean v1, Object v2) {
        return v2 instanceof Boolean && (Boolean)v2 == v1;
    }

    public static boolean equals(char v1, Object v2) {
        return v2 instanceof Character && ((Character)v2).charValue() == v1;
    }

    public static boolean equals(byte v1, Object v2) {
        return v2 instanceof Byte && (Byte)v2 == v1;
    }

    public static boolean equals(short v1, Object v2) {
        return v2 instanceof Short && (Short)v2 == v1;
    }

    public static boolean equals(int v1, Object v2) {
        return v2 instanceof Integer && (Integer)v2 == v1;
    }

    public static boolean equals(long v1, Object v2) {
        return v2 instanceof Long && (Long)v2 == v1;
    }

    public static boolean equals(float v1, Object v2) {
        return v2 instanceof Float && Float.floatToIntBits(((Float)v2).floatValue()) == Float.floatToIntBits(v1);
    }

    public static boolean equals(double v1, Object v2) {
        return v2 instanceof Double && Double.doubleToLongBits((Double)v2) == Double.doubleToLongBits(v1);
    }

    public static boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    public static boolean isAssertionEnabled() {
        return isAssertionEnabled;
    }

    public static void assertFail() {
        if (isAssertionEnabled) {
            throw new AssertionError((Object)"assertion failed");
        }
    }

    public static void assertFail(String message) {
        if (isAssertionEnabled) {
            throw new AssertionError((Object)message);
        }
    }

    public static void assertFail(Throwable cause) {
        if (isAssertionEnabled) {
            throw new AssertionError("assertion failed", cause);
        }
    }

    public static void assertFail(String message, Throwable cause) {
        if (isAssertionEnabled) {
            throw new AssertionError(message, cause);
        }
    }

    public static void assertFail(@NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertFail(@NotNull Supplier<?> messageSupplier, Throwable cause) {
        if (isAssertionEnabled) {
            throw new AssertionError(Objects.toString(messageSupplier.get()), cause);
        }
    }

    public static void assertTrue(boolean condition) {
        if (isAssertionEnabled && !condition) {
            throw new AssertionError((Object)"assertion failed");
        }
    }

    public static void assertTrue(boolean condition, Object message) {
        if (isAssertionEnabled && !condition) {
            throw new AssertionError(message);
        }
    }

    public static void assertTrue(boolean condition, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && !condition) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertTrue(@NotNull BooleanSupplier condition) {
        if (isAssertionEnabled && !condition.getAsBoolean()) {
            throw new AssertionError((Object)"assertion failed");
        }
    }

    public static void assertTrue(@NotNull BooleanSupplier condition, Object message) {
        if (isAssertionEnabled && !condition.getAsBoolean()) {
            throw new AssertionError(message);
        }
    }

    public static void assertTrue(@NotNull BooleanSupplier condition, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && !condition.getAsBoolean()) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertFalse(boolean condition) {
        if (isAssertionEnabled && condition) {
            throw new AssertionError((Object)"assertion failed");
        }
    }

    public static void assertFalse(boolean condition, Object message) {
        if (isAssertionEnabled && condition) {
            throw new AssertionError(message);
        }
    }

    public static void assertFalse(boolean condition, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && condition) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertFalse(@NotNull BooleanSupplier condition) {
        if (isAssertionEnabled && condition.getAsBoolean()) {
            throw new AssertionError((Object)"assertion failed");
        }
    }

    public static void assertFalse(@NotNull BooleanSupplier condition, Object message) {
        if (isAssertionEnabled && condition.getAsBoolean()) {
            throw new AssertionError(message);
        }
    }

    public static void assertFalse(@NotNull BooleanSupplier condition, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && condition.getAsBoolean()) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertNull(Object actual) {
        if (isAssertionEnabled && actual != null) {
            throw new AssertionError((Object)("Expected value to be null, but was: <" + actual + ">"));
        }
    }

    public static void assertNull(Object actual, Object message) {
        if (isAssertionEnabled && actual != null) {
            throw new AssertionError(message);
        }
    }

    public static void assertNull(Object actual, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && actual != null) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertNull(@NotNull Supplier<?> actualSupplier) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) != null) {
            throw new AssertionError((Object)("Expected value to be null, but was: <" + actual + ">"));
        }
    }

    public static void assertNull(@NotNull Supplier<?> actualSupplier, Object message) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) != null) {
            throw new AssertionError(message);
        }
    }

    public static void assertNull(@NotNull Supplier<?> actualSupplier, @NotNull Supplier<?> messageSupplier) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) != null) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertNotNull(Object actual) {
        if (isAssertionEnabled && actual == null) {
            throw new AssertionError((Object)"Expected value to be not null");
        }
    }

    public static void assertNotNull(Object actual, Object message) {
        if (isAssertionEnabled && actual == null) {
            throw new AssertionError(message);
        }
    }

    public static void assertNotNull(Object actual, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && actual == null) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertNotNull(@NotNull Supplier<?> actualSupplier) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) == null) {
            throw new AssertionError((Object)"Expected value to be not null");
        }
    }

    public static void assertNotNull(@NotNull Supplier<?> actualSupplier, Object message) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) == null) {
            throw new AssertionError(message);
        }
    }

    public static void assertNotNull(@NotNull Supplier<?> actualSupplier, @NotNull Supplier<?> messageSupplier) {
        Object actual;
        if (isAssertionEnabled && (actual = actualSupplier.get()) == null) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        if (isAssertionEnabled && !Objects.equals(expected, actual)) {
            throw new AssertionError((Object)("Expected < " + expected + ">, actual <" + actual + ">"));
        }
    }

    public static void assertEquals(Object expected, Object actual, Object message) {
        if (isAssertionEnabled && !Objects.equals(expected, actual)) {
            throw new AssertionError(message);
        }
    }

    public static void assertEquals(Object expected, Object actual, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && !Objects.equals(expected, actual)) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertEquals(float expected, float actual, float absoluteTolerance) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(expected) != Float.floatToIntBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError((Object)("Expected < " + expected + ">, actual <" + actual + ">"));
            }
        }
    }

    public static void assertEquals(float expected, float actual, float absoluteTolerance, Object message) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(expected) != Float.floatToIntBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError(message);
            }
        }
    }

    public static void assertEquals(float expected, float actual, float absoluteTolerance, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(expected) != Float.floatToIntBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError(messageSupplier.get());
            }
        }
    }

    public static void assertEquals(double expected, double actual, double absoluteTolerance) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(expected) != Double.doubleToLongBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError((Object)("Expected < " + expected + ">, actual <" + actual + ">"));
            }
        }
    }

    public static void assertEquals(double expected, double actual, double absoluteTolerance, Object message) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(expected) != Double.doubleToLongBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError(message);
            }
        }
    }

    public static void assertEquals(double expected, double actual, double absoluteTolerance, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(expected) != Double.doubleToLongBits(actual) && !(Math.abs(expected - actual) <= absoluteTolerance)) {
                throw new AssertionError(messageSupplier.get());
            }
        }
    }

    public static void assertNotEquals(Object illegal, Object actual) {
        if (isAssertionEnabled && Objects.equals(illegal, actual)) {
            throw new AssertionError((Object)("Illegal value: <" + actual + ">"));
        }
    }

    public static void assertNotEquals(Object illegal, Object actual, Object message) {
        if (isAssertionEnabled && Objects.equals(illegal, actual)) {
            throw new AssertionError(message);
        }
    }

    public static void assertNotEquals(Object illegal, Object actual, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled && Objects.equals(illegal, actual)) {
            throw new AssertionError(messageSupplier.get());
        }
    }

    public static void assertNotEquals(float illegal, float actual, float absoluteTolerance) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(illegal) == Float.floatToIntBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError((Object)("Illegal value: <" + actual + ">"));
            }
        }
    }

    public static void assertNotEquals(float illegal, float actual, float absoluteTolerance, Object message) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(illegal) == Float.floatToIntBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError(message);
            }
        }
    }

    public static void assertNotEquals(float illegal, float actual, float absoluteTolerance, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled) {
            if ((double)absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Float.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Float.floatToIntBits(illegal) == Float.floatToIntBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError(messageSupplier.get());
            }
        }
    }

    public static void assertNotEquals(double illegal, double actual, double absoluteTolerance) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(illegal) == Double.doubleToLongBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError((Object)("Illegal value: <" + actual + ">"));
            }
        }
    }

    public static void assertNotEquals(double illegal, double actual, double absoluteTolerance, Object message) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(illegal) == Double.doubleToLongBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError(message);
            }
        }
    }

    public static void assertNotEquals(double illegal, double actual, double absoluteTolerance, @NotNull Supplier<?> messageSupplier) {
        if (isAssertionEnabled) {
            if (absoluteTolerance < 0.0) {
                throw new IllegalArgumentException("Illegal negative absolute tolerance <" + absoluteTolerance + '>');
            }
            if (Double.isNaN(absoluteTolerance)) {
                throw new IllegalArgumentException("Illegal NaN absolute tolerance <" + absoluteTolerance + ">");
            }
            if (Double.doubleToLongBits(illegal) == Double.doubleToLongBits(actual) || Math.abs(illegal - actual) <= absoluteTolerance) {
                throw new AssertionError(messageSupplier.get());
            }
        }
    }

    static {
        boolean b = false;
        if (!$assertionsDisabled) {
            b = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        isAssertionEnabled = b;
    }
}

