/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.ObjectArrays;
import kala.collection.factory.CollectionFactory;
import kala.control.Option;
import kala.control.Try;
import kala.function.CheckedConsumer;
import kala.function.IndexedBiConsumer;
import kala.function.IndexedBiFunction;
import kala.function.IndexedConsumer;
import kala.function.IndexedFunction;
import kala.internal.InternalIdentifyObject;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Iterators {
    private static final Iterator<?> EMPTY = new AbstractIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public String toString() {
            return "Iterator[]";
        }
    };
    static final Object TAG_VALUE = new InternalIdentifyObject();

    private Iterators() {
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> Iterator<E> narrow(Iterator<? extends E> iterator) {
        return iterator;
    }

    @NotNull
    public static <E> Iterator<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> Iterator<E> of() {
        return Iterators.empty();
    }

    @NotNull
    public static <E> Iterator<E> of(E value1) {
        return value1 == null ? new OfNull() : new OfNotNull<E>(value1);
    }

    @NotNull
    public static <E> Iterator<E> of(E value1, E value2) {
        return new Itr2<E>(value1, value2);
    }

    @NotNull
    public static <E> Iterator<E> of(E value1, E value2, E value3) {
        return new Itr3<E>(value1, value2, value3);
    }

    @NotNull
    public static <E> Iterator<E> of(E value1, E value2, E value3, E value4) {
        return new Itr4<E>(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> Iterator<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new Itr5<E>(value1, value2, value3, value4, value5);
    }

    @SafeVarargs
    @NotNull
    public static <E> Iterator<E> of(E ... values) {
        return GenericArrays.iterator(values);
    }

    @NotNull
    public static <E> Iterator<E> ofEnumeration(final @NotNull Enumeration<? extends E> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return Iterators.empty();
        }
        return new AbstractIterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }

            @Override
            public String toString() {
                return "Iterators.OfEnumeration[" + enumeration + "]";
            }
        };
    }

    @NotNull
    public static <E> Iterator<E> from(E @NotNull [] values) {
        return GenericArrays.iterator(values);
    }

    @NotNull
    public static <E> Iterator<E> from(@NotNull Iterable<? extends E> values) {
        return Iterators.narrow(values.iterator());
    }

    @NotNull
    public static <E> Iterator<E> from(@NotNull Iterator<? extends E> it) {
        return Iterators.narrow(Objects.requireNonNull(it));
    }

    @NotNull
    public static <E> Iterator<E> from(@NotNull Stream<? extends E> stream) {
        return Iterators.narrow(stream.iterator());
    }

    @NotNull
    public static <E> Iterator<E> fill(int n, E value) {
        if (n <= 0) {
            return Iterators.empty();
        }
        if (n == 1) {
            return Iterators.of(value);
        }
        return new Copies<E>(n, value);
    }

    @NotNull
    public static <E> Iterator<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return Iterators.empty();
        }
        if (n == 1) {
            return Iterators.of(supplier.get());
        }
        Objects.requireNonNull(supplier);
        return new FillSupplier<E>(n, supplier);
    }

    @NotNull
    public static <E> Iterator<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return Iterators.empty();
        }
        if (n == 1) {
            return Iterators.of(init.apply(0));
        }
        Objects.requireNonNull(init);
        return new FillIntFunction<E>(n, init);
    }

    @NotNull
    public static <E> Iterator<E> concat(@NotNull Iterator<? extends E> it1, @NotNull Iterator<? extends E> it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new Concat<E>(it1, it2);
    }

    @NotNull
    public static <E> Iterator<E> concat(Iterator<? extends E> ... its) {
        switch (its.length) {
            case 0: {
                return Iterators.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return Iterators.concat(its[0], its[1]);
            }
        }
        return new ConcatAll<E>(GenericArrays.iterator(its));
    }

    @NotNull
    public static <E> Iterator<E> concat(@NotNull Iterable<? extends Iterator<? extends E>> its) {
        return Iterators.concat(its.iterator());
    }

    @NotNull
    public static <E> Iterator<E> concat(@NotNull Iterator<? extends Iterator<? extends E>> its) {
        if (!its.hasNext()) {
            return Iterators.empty();
        }
        return new ConcatAll(its);
    }

    @Contract(mutates="param1")
    public static int hash(@NotNull Iterator<?> it) {
        int res = 0;
        while (it.hasNext()) {
            res = res * 31 + Objects.hashCode(it.next());
        }
        return res;
    }

    public static int size(@NotNull Iterator<?> it) {
        int i = 0;
        while (it.hasNext()) {
            it.next();
            ++i;
        }
        return i;
    }

    public static <E> Iterator<E> reversed(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return it;
        }
        ArrayList<E> list = new ArrayList<E>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return GenericArrays.reverseIterator(list.toArray());
    }

    public static boolean contains(Iterator<?> it, Object value) {
        if (value == null) {
            while (it.hasNext()) {
                if (null != it.next()) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!value.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean sameElements(@NotNull Iterator<?> it1, @NotNull Iterator<?> it2) {
        while (it1.hasNext() && it2.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext();
    }

    public static boolean sameElements(@NotNull Iterator<?> it1, @NotNull Iterator<?> it2, boolean identity) {
        if (!identity) {
            return Iterators.sameElements(it1, it2);
        }
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next() == it2.next()) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext();
    }

    public static <E> int count(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        int c = 0;
        while (it.hasNext()) {
            if (!predicate.test(it.next())) continue;
            ++c;
        }
        return c;
    }

    public static <E> boolean anyMatch(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            if (!predicate.test(it.next())) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean allMatch(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            if (predicate.test(it.next())) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean noneMatch(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            if (!predicate.test(it.next())) continue;
            return false;
        }
        return true;
    }

    public static <E> E first(@NotNull Iterator<? extends E> it) {
        return it.next();
    }

    public static <E> E first(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            return e;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    public static <E> E firstOrNull(@NotNull Iterator<? extends E> it) {
        return it.hasNext() ? (E)it.next() : null;
    }

    @Nullable
    public static <E> E firstOrNull(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    @NotNull
    public static <E> Option<E> firstOption(@NotNull Iterator<? extends E> it) {
        return it.hasNext() ? Option.some(it.next()) : Option.none();
    }

    @NotNull
    public static <E> Option<E> firstOption(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            return Option.some(e);
        }
        return Option.none();
    }

    public static <E> E last(@NotNull Iterator<? extends E> it) {
        E res = it.next();
        while (it.hasNext()) {
            res = it.next();
        }
        return res;
    }

    public static <E> E last(@NotNull Iterator<? extends E> it, Predicate<? super E> predicate) {
        E res = null;
        boolean hasValue = false;
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            hasValue = true;
            res = e;
        }
        if (!hasValue) {
            throw new NoSuchElementException();
        }
        return res;
    }

    @Nullable
    public static <E> E lastOrNull(@NotNull Iterator<? extends E> it) {
        E res = null;
        while (it.hasNext()) {
            res = it.next();
        }
        return res;
    }

    @Nullable
    public static <E> E lastOrNull(@NotNull Iterator<? extends E> it, Predicate<? super E> predicate) {
        E res = null;
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            res = e;
        }
        return res;
    }

    @NotNull
    public static <E> Option<E> lastOption(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return Option.none();
        }
        Object res = null;
        while (it.hasNext()) {
            res = it.next();
        }
        return Option.some(res);
    }

    @NotNull
    public static <E> Option<E> lastOption(@NotNull Iterator<? extends E> it, Predicate<? super E> predicate) {
        Object res = null;
        boolean hasValue = false;
        while (it.hasNext()) {
            E e = it.next();
            if (!predicate.test(e)) continue;
            hasValue = true;
            res = e;
        }
        return hasValue ? Option.some(res) : Option.none();
    }

    public static <E extends Comparable<E>> E max(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) <= 0) continue;
            e = v;
        }
        return (E)e;
    }

    public static <E> E max(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) <= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) <= 0) continue;
                e = v;
            }
        }
        return e;
    }

    @Nullable
    public static <E extends Comparable<E>> E maxOrNull(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return null;
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) <= 0) continue;
            e = v;
        }
        return (E)e;
    }

    @Nullable
    public static <E> E maxOrNull(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            return null;
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) <= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) <= 0) continue;
                e = v;
            }
        }
        return e;
    }

    @NotNull
    public static <E extends Comparable<E>> Option<E> maxOption(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return Option.none();
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) <= 0) continue;
            e = v;
        }
        return Option.some(e);
    }

    @NotNull
    public static <E> Option<E> maxOption(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            return Option.none();
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) <= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) <= 0) continue;
                e = v;
            }
        }
        return Option.some(e);
    }

    public static <E extends Comparable<E>> E min(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) >= 0) continue;
            e = v;
        }
        return (E)e;
    }

    public static <E> E min(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) >= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) >= 0) continue;
                e = v;
            }
        }
        return e;
    }

    @Nullable
    public static <E extends Comparable<E>> E minOrNull(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return null;
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) >= 0) continue;
            e = v;
        }
        return (E)e;
    }

    @Nullable
    public static <E> E minOrNull(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            return null;
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) >= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) >= 0) continue;
                e = v;
            }
        }
        return e;
    }

    @NotNull
    public static <E extends Comparable<E>> Option<E> minOption(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return Option.none();
        }
        Comparable e = (Comparable)it.next();
        while (it.hasNext()) {
            Comparable v = (Comparable)it.next();
            if (v.compareTo(e) >= 0) continue;
            e = v;
        }
        return Option.some(e);
    }

    @NotNull
    public static <E> Option<E> minOption(@NotNull Iterator<? extends E> it, Comparator<? super E> comparator) {
        if (!it.hasNext()) {
            return Option.none();
        }
        E e = it.next();
        if (comparator == null) {
            while (it.hasNext()) {
                E v = it.next();
                if (((Comparable)v).compareTo(e) >= 0) continue;
                e = v;
            }
        } else {
            while (it.hasNext()) {
                E v = it.next();
                if (comparator.compare(v, e) >= 0) continue;
                e = v;
            }
        }
        return Option.some(e);
    }

    @Contract(mutates="param1")
    @NotNull
    public static <E> Iterator<E> drop(@NotNull Iterator<? extends E> it, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && it.hasNext()) {
            it.next();
            --n;
        }
        return it;
    }

    @NotNull
    public static <E> Iterator<E> dropWhile(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        while (it.hasNext()) {
            E value = it.next();
            if (predicate.test(value)) continue;
            return it.hasNext() ? Iterators.prepended(it, value) : Iterators.of(value);
        }
        return Iterators.empty();
    }

    @NotNull
    public static <E> Iterator<E> take(@NotNull Iterator<? extends E> it, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0 || !it.hasNext()) {
            return Iterators.empty();
        }
        return new Take<E>(it, n);
    }

    @NotNull
    public static <E> Iterator<E> takeWhile(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new TakeWhile<E>(it, predicate);
    }

    @NotNull
    public static <E> Iterator<E> updated(final @NotNull Iterator<? extends E> it, final int n, final E newValue) {
        if (!it.hasNext() || n < 0) {
            return it;
        }
        if (n == 0) {
            it.next();
            return Iterators.prepended(it, newValue);
        }
        return new AbstractIterator<E>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                if (this.idx++ == n) {
                    it.next();
                    return newValue;
                }
                return it.next();
            }
        };
    }

    @NotNull
    public static <E> Iterator<E> appended(@NotNull Iterator<? extends E> it, E value) {
        if (!it.hasNext()) {
            return Iterators.of(value);
        }
        return value == null ? new AppendedNull<E>(it) : new AppendedNotNull<E>(it, value);
    }

    @NotNull
    public static <E> Iterator<E> prepended(@NotNull Iterator<? extends E> it, E value) {
        if (!it.hasNext()) {
            return Iterators.of(value);
        }
        return value == null ? new PrependedNull<E>(it) : new PrependedNotNull<E>(it, value);
    }

    @NotNull
    public static <E> Iterator<E> filter(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new Filter<E>(it, predicate);
    }

    @NotNull
    public static <E> Iterator<E> filterNot(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new FilterNot<E>(it, predicate);
    }

    @NotNull
    public static <E> @NotNull Iterator<@NotNull E> filterNotNull(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new FilterNotNull<E>(it);
    }

    @NotNull
    public static <E, U> Iterator<U> map(final @NotNull Iterator<? extends E> it, final @NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(it.next());
            }
        };
    }

    @NotNull
    public static <E, U> Iterator<U> mapIndexed(final @NotNull Iterator<? extends E> it, final @NotNull IndexedFunction<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public U next() {
                Object nextValue = it.next();
                return mapper.apply(this.idx++, nextValue);
            }
        };
    }

    @NotNull
    public static <E, U> Iterator<U> mapNotNull(@NotNull Iterator<? extends E> it, @NotNull Function<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new MapNotNull<E, U>(it, mapper);
    }

    @NotNull
    public static <E, U> Iterator<U> mapIndexedNotNull(@NotNull Iterator<? extends E> it, @NotNull IndexedFunction<? super E, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new MapIndexedNotNull<E, U>(it, mapper);
    }

    @NotNull
    public static <E, U> Iterator<U> mapMulti(@NotNull Iterator<? extends E> it, @NotNull BiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new MapMulti(it, mapper);
    }

    @NotNull
    public static <E, U> Iterator<U> mapIndexedMulti(@NotNull Iterator<? extends E> it, @NotNull IndexedBiConsumer<? super E, ? super Consumer<? super U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new MapIndexedMulti(it, mapper);
    }

    @NotNull
    public static <E, U> Iterator<U> flatMap(@NotNull Iterator<? extends E> it, @NotNull Function<? super E, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!it.hasNext()) {
            return Iterators.empty();
        }
        return new ConcatAll(Iterators.map(Iterators.map(it, mapper), Iterable::iterator));
    }

    @NotNull
    public static <E, U> @NotNull Iterator<@NotNull Tuple2<E, U>> zip(@NotNull Iterator<? extends E> it1, Iterator<? extends U> it2) {
        if (!it1.hasNext() || !it2.hasNext()) {
            return Iterators.empty();
        }
        return new Zip<E, U>(it1, it2);
    }

    @NotNull
    public static <E> Tuple2<Iterator<E>, Iterator<E>> span(@NotNull Iterator<? extends E> it, @NotNull Predicate<? super E> predicate) {
        if (!it.hasNext()) {
            return Tuple.of(Iterators.empty(), Iterators.empty());
        }
        ArrayList<E> list = new ArrayList<E>();
        while (it.hasNext()) {
            E e = it.next();
            if (predicate.test(e)) {
                list.add(e);
                continue;
            }
            it = Iterators.prepended(it, e);
            break;
        }
        return new Tuple2<Iterator<E>, Iterator<E>>(list.iterator(), Iterators.narrow(it));
    }

    public static <E> E fold(@NotNull Iterator<? extends E> it, E zero, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return Iterators.foldLeft(it, zero, op);
    }

    public static <E, U> U foldLeft(@NotNull Iterator<? extends E> it, U zero, @NotNull BiFunction<? super U, ? super E, ? extends U> op) {
        while (it.hasNext()) {
            zero = op.apply(zero, it.next());
        }
        return zero;
    }

    public static <E, U> U foldRight(@NotNull Iterator<? extends E> it, U zero, @NotNull BiFunction<? super E, ? super U, ? extends U> op) {
        if (!it.hasNext()) {
            return zero;
        }
        ArrayList<E> list = new ArrayList<E>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            zero = op.apply(list.get(i), zero);
        }
        return zero;
    }

    public static <E> E foldIndexed(@NotNull Iterator<? extends E> it, E zero, @NotNull IndexedBiFunction<? super E, ? super E, ? extends E> op) {
        return Iterators.foldLeftIndexed(it, zero, op);
    }

    public static <E, U> U foldLeftIndexed(@NotNull Iterator<? extends E> it, U zero, @NotNull IndexedBiFunction<? super U, ? super E, ? extends U> op) {
        int idx = 0;
        while (it.hasNext()) {
            zero = op.apply(idx++, zero, it.next());
        }
        return zero;
    }

    public static <E, U> U foldRightIndexed(@NotNull Iterator<? extends E> it, U zero, @NotNull IndexedBiFunction<? super E, ? super U, ? extends U> op) {
        if (!it.hasNext()) {
            return zero;
        }
        ArrayList<E> list = new ArrayList<E>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            zero = op.apply(i, list.get(i), zero);
        }
        return zero;
    }

    public static <E> E reduce(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return Iterators.reduceLeft(it, op);
    }

    @Nullable
    public static <E> E reduceOrNull(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return Iterators.reduceLeftOrNull(it, op);
    }

    @NotNull
    public static <E> Option<E> reduceOption(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return Iterators.reduceLeftOption(it, op);
    }

    public static <E> E reduceLeft(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        E e = it.next();
        while (it.hasNext()) {
            e = op.apply(e, it.next());
        }
        return e;
    }

    @Nullable
    public static <E> E reduceLeftOrNull(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return it.hasNext() ? (E)Iterators.reduceLeft(it, op) : null;
    }

    @NotNull
    public static <E> Option<E> reduceLeftOption(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return it.hasNext() ? Option.some(Iterators.reduceLeft(it, op)) : Option.none();
    }

    public static <E> E reduceRight(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<E> list = new ArrayList<E>();
        list.add(it.next());
        while (it.hasNext()) {
            list.add(it.next());
        }
        int size = list.size();
        Object e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.apply(list.get(i), e);
        }
        return e;
    }

    @Nullable
    public static <E> E reduceRightOrNull(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return it.hasNext() ? (E)Iterators.reduceRight(it, op) : null;
    }

    @NotNull
    public static <E> Option<E> reduceRightOption(@NotNull Iterator<? extends E> it, @NotNull BiFunction<? super E, ? super E, ? extends E> op) {
        return it.hasNext() ? Option.some(Iterators.reduceRight(it, op)) : Option.none();
    }

    public static Object @NotNull [] toArray(@NotNull Iterator<?> it) {
        if (!it.hasNext()) {
            return ObjectArrays.EMPTY;
        }
        ArrayList buffer = new ArrayList();
        while (it.hasNext()) {
            buffer.add(it.next());
        }
        return buffer.toArray();
    }

    public static <E> E @NotNull [] toArray(@NotNull Iterator<? extends E> it, @NotNull Class<E> type) {
        Objects.requireNonNull(type);
        Object[] emptyArray = (Object[])Array.newInstance(type, 0);
        if (!it.hasNext()) {
            return emptyArray;
        }
        ArrayList<E> buffer = new ArrayList<E>();
        while (it.hasNext()) {
            buffer.add(it.next());
        }
        return buffer.toArray(emptyArray);
    }

    public static <E> E @NotNull [] toArray(@NotNull Iterator<? extends E> it, @NotNull IntFunction<E[]> generator) {
        Objects.requireNonNull(generator);
        if (!it.hasNext()) {
            return generator.apply(0);
        }
        ArrayList<E> buffer = new ArrayList<E>();
        while (it.hasNext()) {
            buffer.add(it.next());
        }
        return buffer.toArray(generator.apply(buffer.size()));
    }

    public static <E, R, Builder> R collect(@NotNull Iterator<? extends E> it, @NotNull Collector<? super E, Builder, ? extends R> collector) {
        Builder builder = collector.supplier().get();
        if (!it.hasNext()) {
            return collector.finisher().apply(builder);
        }
        BiConsumer<Builder, E> accumulator = collector.accumulator();
        while (it.hasNext()) {
            accumulator.accept(builder, it.next());
        }
        return collector.finisher().apply(builder);
    }

    static <E, R, Builder> R collect(@NotNull Iterator<? extends E> it, @NotNull CollectionFactory<? super E, Builder, ? extends R> factory) {
        if (!it.hasNext()) {
            return factory.empty();
        }
        Builder builder = factory.newBuilder();
        while (it.hasNext()) {
            factory.addToBuilder(builder, it.next());
        }
        return factory.build(builder);
    }

    @Contract(value="_, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <A extends Appendable> A joinTo(@NotNull Iterator<?> it, @NotNull A buffer) {
        return Iterators.joinTo(it, buffer, ", ", "", "");
    }

    @Contract(value="_, _, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <A extends Appendable> A joinTo(@NotNull Iterator<?> it, @NotNull A buffer, CharSequence separator) {
        return Iterators.joinTo(it, buffer, separator, "", "");
    }

    @Contract(value="_, _, _, _, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <A extends Appendable> A joinTo(@NotNull Iterator<?> it, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (it.hasNext()) {
                buffer.append(Objects.toString(it.next()));
            }
            while (it.hasNext()) {
                buffer.append(separator).append(Objects.toString(it.next()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Contract(value="_, _, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <E, A extends Appendable> A joinTo(@NotNull Iterator<? extends E> it, @NotNull A buffer, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return Iterators.joinTo(it, buffer, ", ", "", "", transform);
    }

    @Contract(value="_, _, _, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <E, A extends Appendable> A joinTo(@NotNull Iterator<? extends E> it, @NotNull A buffer, CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return Iterators.joinTo(it, buffer, separator, "", "", transform);
    }

    @Contract(value="_, _, _, _, _, _ -> param2", mutates="param1, param2")
    @NotNull
    public static <E, A extends Appendable> A joinTo(@NotNull Iterator<? extends E> it, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        try {
            buffer.append(prefix);
            if (it.hasNext()) {
                buffer.append(transform.apply(it.next()));
            }
            while (it.hasNext()) {
                buffer.append(separator).append(transform.apply(it.next()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @NotNull
    public static String joinToString(@NotNull Iterator<?> it) {
        return Iterators.joinTo(it, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(@NotNull Iterator<?> it, CharSequence separator) {
        return Iterators.joinTo(it, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(@NotNull Iterator<?> it, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return Iterators.joinTo(it, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static <E> String joinToString(@NotNull Iterator<? extends E> it, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return Iterators.joinTo(it, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static <E> String joinToString(@NotNull Iterator<? extends E> it, CharSequence separator, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return Iterators.joinTo(it, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static <E> String joinToString(@NotNull Iterator<? extends E> it, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull Function<? super E, ? extends CharSequence> transform) {
        return Iterators.joinTo(it, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    public static <E> void forEach(@NotNull Iterator<? extends E> it, @NotNull Consumer<? super E> action) {
        while (it.hasNext()) {
            action.accept(it.next());
        }
    }

    public static <E, Ex extends Throwable> void forEachChecked(@NotNull Iterator<? extends E> it, @NotNull CheckedConsumer<? super E, ? extends Ex> action) {
        try {
            while (it.hasNext()) {
                action.acceptChecked(it.next());
            }
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    public static <E> void forEachUnchecked(@NotNull Iterator<? extends E> it, @NotNull CheckedConsumer<? super E, ?> action) {
        try {
            while (it.hasNext()) {
                action.acceptChecked(it.next());
            }
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    public static <E> void forEachIndexed(@NotNull Iterator<? extends E> it, @NotNull IndexedConsumer<? super E> action) {
        int idx = 0;
        while (it.hasNext()) {
            action.accept(idx++, it.next());
        }
    }

    private static final class OfNull<E>
    extends AbstractIterator<E> {
        private boolean hasNext = true;

        private OfNull() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return null;
        }
    }

    private static final class OfNotNull<E>
    extends AbstractIterator<E> {
        @Nullable
        private E value;

        OfNotNull(@NotNull E value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public E next() {
            E v = this.value;
            if (v == null) {
                throw new NoSuchElementException();
            }
            this.value = null;
            return v;
        }
    }

    private static final class Itr2<E>
    extends AbstractIterator<E> {
        private int idx = 0;
        private E value1;
        private E value2;

        Itr2(E value1, E value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        @Override
        public boolean hasNext() {
            return this.idx < 2;
        }

        @Override
        public E next() {
            E res;
            switch (this.idx) {
                case 0: {
                    res = this.value1;
                    this.value1 = null;
                    break;
                }
                case 1: {
                    res = this.value2;
                    this.value2 = null;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++this.idx;
            return res;
        }
    }

    private static final class Itr3<E>
    extends AbstractIterator<E> {
        private int idx = 0;
        private E value1;
        private E value2;
        private E value3;

        Itr3(E value1, E value2, E value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        @Override
        public boolean hasNext() {
            return this.idx < 3;
        }

        @Override
        public E next() {
            E res;
            switch (this.idx) {
                case 0: {
                    res = this.value1;
                    this.value1 = null;
                    break;
                }
                case 1: {
                    res = this.value2;
                    this.value2 = null;
                    break;
                }
                case 2: {
                    res = this.value3;
                    this.value3 = null;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++this.idx;
            return res;
        }
    }

    private static final class Itr4<E>
    extends AbstractIterator<E> {
        private int idx = 0;
        private E value1;
        private E value2;
        private E value3;
        private E value4;

        Itr4(E value1, E value2, E value3, E value4) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
            this.value4 = value4;
        }

        @Override
        public boolean hasNext() {
            return this.idx < 4;
        }

        @Override
        public E next() {
            E res;
            switch (this.idx) {
                case 0: {
                    res = this.value1;
                    this.value1 = null;
                    break;
                }
                case 1: {
                    res = this.value2;
                    this.value2 = null;
                    break;
                }
                case 2: {
                    res = this.value3;
                    this.value3 = null;
                    break;
                }
                case 3: {
                    res = this.value4;
                    this.value4 = null;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++this.idx;
            return res;
        }
    }

    private static final class Itr5<E>
    extends AbstractIterator<E> {
        private int idx = 0;
        private E value1;
        private E value2;
        private E value3;
        private E value4;
        private E value5;

        Itr5(E value1, E value2, E value3, E value4, E value5) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
            this.value4 = value4;
            this.value5 = value5;
        }

        @Override
        public boolean hasNext() {
            return this.idx < 5;
        }

        @Override
        public E next() {
            E res;
            switch (this.idx) {
                case 0: {
                    res = this.value1;
                    this.value1 = null;
                    break;
                }
                case 1: {
                    res = this.value2;
                    this.value2 = null;
                    break;
                }
                case 2: {
                    res = this.value3;
                    this.value3 = null;
                    break;
                }
                case 3: {
                    res = this.value4;
                    this.value4 = null;
                    break;
                }
                case 4: {
                    res = this.value5;
                    this.value5 = null;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++this.idx;
            return res;
        }
    }

    private static final class Copies<E>
    extends AbstractIterator<E> {
        private int n;
        private E value;

        Copies(int n, E value) {
            this.n = n;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0;
        }

        @Override
        public E next() {
            if (this.n <= 0) {
                throw new NoSuchElementException();
            }
            E oldValue = this.value;
            if (--this.n == 0) {
                this.value = null;
            }
            return oldValue;
        }
    }

    private static final class FillSupplier<E>
    extends AbstractIterator<E> {
        private int n;
        private Supplier<? extends E> supplier;

        FillSupplier(int n, @NotNull Supplier<? extends E> supplier) {
            this.n = n;
            this.supplier = supplier;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0;
        }

        @Override
        public E next() {
            if (this.n <= 0) {
                throw new NoSuchElementException();
            }
            E res = this.supplier.get();
            if (--this.n == 0) {
                this.supplier = null;
            }
            return res;
        }
    }

    private static final class FillIntFunction<E>
    extends AbstractIterator<E> {
        private final int n;
        private int idx = 0;
        private IntFunction<? extends E> init;

        FillIntFunction(int n, @NotNull IntFunction<? extends E> init) {
            this.n = n;
            this.init = init;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.n;
        }

        @Override
        public E next() {
            if (this.idx >= this.n) {
                throw new NoSuchElementException();
            }
            E res = this.init.apply(this.idx++);
            if (this.idx == this.n) {
                this.init = null;
            }
            return res;
        }
    }

    private static final class Concat<E>
    extends AbstractIterator<E> {
        private Iterator<? extends E> it1;
        private Iterator<? extends E> it2;

        Concat(Iterator<? extends E> it1, Iterator<? extends E> it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.next();
            }
            if (this.it2 != null) {
                return this.it2.next();
            }
            throw new AssertionError();
        }
    }

    private static final class ConcatAll<E>
    extends AbstractIterator<E> {
        @NotNull
        private final Iterator<? extends Iterator<? extends E>> iterators;
        private Iterator<? extends E> current = null;

        ConcatAll(@NotNull Iterator<? extends Iterator<? extends E>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.current.next();
            }
            throw new NoSuchElementException(this + ".next()");
        }
    }

    private static final class Take<E>
    extends AbstractIterator<E> {
        @NotNull
        private final Iterator<? extends E> source;
        private int c;

        Take(@NotNull Iterator<? extends E> source, int c) {
            this.source = source;
            this.c = c;
        }

        @Override
        public boolean hasNext() {
            return this.c > 0 && this.source.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            --this.c;
            return this.source.next();
        }
    }

    private static final class TakeWhile<E>
    extends AbstractIterator<E> {
        @NotNull
        private Iterator<? extends E> source;
        private final Predicate<? super E> predicate;
        private Object nextValue = TAG_VALUE;

        TakeWhile(@NotNull Iterator<? extends E> source, Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != TAG_VALUE) {
                return true;
            }
            if (this.source.hasNext()) {
                E v = this.source.next();
                if (this.predicate.test(v)) {
                    this.nextValue = v;
                    return true;
                }
                this.source = Iterators.empty();
                return false;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                Object nv = this.nextValue;
                this.nextValue = TAG_VALUE;
                return (E)nv;
            }
            throw new NoSuchElementException(this + ".next()");
        }
    }

    private static final class AppendedNull<E>
    extends AbstractIterator<E> {
        private final Iterator<? extends E> source;
        private boolean hasLast = true;

        AppendedNull(Iterator<? extends E> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.hasLast || this.source.hasNext();
        }

        @Override
        public E next() {
            if (this.source.hasNext()) {
                return this.source.next();
            }
            if (this.hasLast) {
                this.hasLast = false;
                return null;
            }
            throw new NoSuchElementException();
        }
    }

    private static final class AppendedNotNull<E>
    extends AbstractIterator<E> {
        private final Iterator<? extends E> source;
        private E last;

        AppendedNotNull(Iterator<? extends E> source, E last) {
            this.source = source;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.last != null || this.source.hasNext();
        }

        @Override
        public E next() {
            if (this.source.hasNext()) {
                return this.source.next();
            }
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            E l = this.last;
            this.last = null;
            return l;
        }
    }

    private static final class PrependedNull<E>
    extends AbstractIterator<E> {
        private final Iterator<? extends E> source;
        private boolean hasHead = true;

        PrependedNull(Iterator<? extends E> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.hasHead || this.source.hasNext();
        }

        @Override
        public E next() {
            if (this.hasHead) {
                this.hasHead = false;
                return null;
            }
            return this.source.next();
        }
    }

    private static final class PrependedNotNull<E>
    extends AbstractIterator<E> {
        private final Iterator<? extends E> source;
        private E head;

        PrependedNotNull(Iterator<? extends E> source, E head) {
            this.source = source;
            this.head = head;
        }

        @Override
        public boolean hasNext() {
            return this.head != null || this.source.hasNext();
        }

        @Override
        public E next() {
            if (this.head != null) {
                E h = this.head;
                this.head = null;
                return h;
            }
            return this.source.next();
        }
    }

    private static final class Filter<E>
    extends AbstractIterator<E> {
        @NotNull
        private final Iterator<? extends E> source;
        @NotNull
        private final Predicate<? super E> predicate;
        private Object nextValue = TAG_VALUE;

        Filter(@NotNull Iterator<? extends E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != TAG_VALUE) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            E v = this.source.next();
            while (!this.predicate.test(v)) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.next();
            }
            this.nextValue = v;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nv = this.nextValue;
            this.nextValue = TAG_VALUE;
            return (E)nv;
        }
    }

    private static final class FilterNot<E>
    extends AbstractIterator<E> {
        @NotNull
        private final Iterator<? extends E> source;
        @NotNull
        private final Predicate<? super E> predicate;
        private Object nextValue = TAG_VALUE;

        FilterNot(@NotNull Iterator<? extends E> source, @NotNull Predicate<? super E> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != TAG_VALUE) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            E v = this.source.next();
            while (this.predicate.test(v)) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.next();
            }
            this.nextValue = v;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nv = this.nextValue;
            this.nextValue = TAG_VALUE;
            return (E)nv;
        }
    }

    private static final class FilterNotNull<E>
    extends AbstractIterator<E> {
        @NotNull
        private final Iterator<? extends E> source;
        private E nextValue = null;

        FilterNotNull(@NotNull Iterator<? extends E> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            E v;
            if (this.nextValue != null) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            while ((v = this.source.next()) == null && this.source.hasNext()) {
            }
            if (v == null) {
                return false;
            }
            this.nextValue = v;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E v = this.nextValue;
            this.nextValue = null;
            return v;
        }
    }

    private static final class MapNotNull<E, U>
    extends AbstractIterator<U> {
        @NotNull
        private final Iterator<? extends E> source;
        @NotNull
        private final Function<? super E, ? extends U> mapper;
        private U nextValue = null;

        MapNotNull(@NotNull Iterator<? extends E> source, @NotNull Function<? super E, ? extends U> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            U v;
            if (this.nextValue != null) {
                return true;
            }
            do {
                if (this.source.hasNext()) continue;
                return false;
            } while ((v = this.mapper.apply(this.source.next())) == null);
            this.nextValue = v;
            return true;
        }

        @Override
        public U next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            U nv = this.nextValue;
            this.nextValue = null;
            return nv;
        }
    }

    private static final class MapIndexedNotNull<E, U>
    extends AbstractIterator<U> {
        @NotNull
        private final Iterator<? extends E> source;
        @NotNull
        private final IndexedFunction<? super E, ? extends U> mapper;
        private int idx = 0;
        private Object nextValue = null;

        MapIndexedNotNull(@NotNull Iterator<? extends E> source, @NotNull IndexedFunction<? super E, ? extends U> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            U v;
            if (this.nextValue != null) {
                return true;
            }
            do {
                if (this.source.hasNext()) continue;
                return false;
            } while ((v = this.mapper.apply(this.idx++, this.source.next())) == null);
            this.nextValue = v;
            return true;
        }

        @Override
        public U next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nv = this.nextValue;
            this.nextValue = null;
            return (U)nv;
        }
    }

    private static final class MapMulti<E, T>
    extends AbstractIterator<E> {
        private Iterator<? extends T> source;
        private BiConsumer<? super T, ? super Consumer<? super E>> mapper;
        private ArrayDeque<E> tmp = new ArrayDeque();
        private Consumer<E> consumer = this.tmp::addLast;

        MapMulti(@NotNull Iterator<? extends T> source, @NotNull BiConsumer<? super T, ? super Consumer<? super E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            if (this.source == null) {
                return false;
            }
            while (this.tmp.isEmpty() && this.source.hasNext()) {
                this.mapper.accept(this.source.next(), this.consumer);
            }
            if (this.tmp.isEmpty()) {
                this.source = null;
                this.mapper = null;
                this.tmp = null;
                this.consumer = null;
                return false;
            }
            return true;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.tmp.removeFirst();
            }
            throw new NoSuchElementException();
        }
    }

    private static final class MapIndexedMulti<E, T>
    extends AbstractIterator<E> {
        private Iterator<? extends T> source;
        private IndexedBiConsumer<? super T, ? super Consumer<? super E>> mapper;
        private ArrayDeque<E> tmp = new ArrayDeque();
        private Consumer<E> consumer = this.tmp::addLast;
        private int idx = 0;

        MapIndexedMulti(@NotNull Iterator<? extends T> source, @NotNull IndexedBiConsumer<? super T, ? super Consumer<? super E>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            if (this.source == null) {
                return false;
            }
            while (this.tmp.isEmpty() && this.source.hasNext()) {
                this.mapper.accept(this.idx++, this.source.next(), this.consumer);
            }
            if (this.tmp.isEmpty()) {
                this.source = null;
                this.mapper = null;
                this.tmp = null;
                this.consumer = null;
                return false;
            }
            return true;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.tmp.removeFirst();
            }
            throw new NoSuchElementException();
        }
    }

    private static final class Zip<E, U>
    extends AbstractIterator<Tuple2<E, U>> {
        private Iterator<? extends E> it1;
        private Iterator<? extends U> it2;

        Zip(Iterator<? extends E> it1, Iterator<? extends U> it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null && this.it1.hasNext() && this.it2.hasNext()) {
                return true;
            }
            this.it1 = null;
            this.it2 = null;
            return false;
        }

        @Override
        @NotNull
        public Tuple2<E, U> next() {
            if (this.hasNext()) {
                return Tuple.of(this.it1.next(), this.it2.next());
            }
            throw new NoSuchElementException();
        }
    }
}

