/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import kala.Conditions;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.control.primitive.FloatOption;
import kala.function.FloatBinaryOperator;
import kala.function.FloatFunction;
import kala.function.FloatObjBiFunction;
import kala.function.FloatPredicate;
import kala.function.ObjFloatBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FloatArrays {
    public static final float[] EMPTY = new float[0];
    private static final IntFunction<float[]> GENERATOR = float[]::new;

    private FloatArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<float[]> generator() {
        return GENERATOR;
    }

    public static float @NotNull [] create(int length) {
        return new float[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static float @NotNull [] of(float ... values) {
        return values;
    }

    public static float @NotNull [] from(float @NotNull [] values) {
        return (float[])values.clone();
    }

    public static float @NotNull [] from(@NotNull FloatTraversable values) {
        return values.toArray();
    }

    public static float @NotNull [] from(@NotNull FloatIterator it) {
        return it.toArray();
    }

    @NotNull
    public static String className(float @NotNull [] array) {
        return "float[]";
    }

    @NotNull
    public static FloatIterator iterator(float @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return FloatIterator.empty();
            }
            case 1: {
                return FloatIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static FloatIterator iterator(float @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return FloatIterator.empty();
            }
            case 1: {
                return FloatIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static FloatIterator iterator(float @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return FloatIterator.empty();
            }
            case 1: {
                return FloatIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    public static boolean isEmpty(float @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(float @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(float @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(float @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static float get(float @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Float getOrNull(float @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Float.valueOf(array[index]) : null;
    }

    @NotNull
    public static FloatOption getOption(float @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? FloatOption.some(array[index]) : FloatOption.none();
    }

    public static void set(float @NotNull [] array, int index, float value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static float @NotNull [] reversed(float @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        float[] res = new float[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static FloatIterator reverseIterator(float @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return FloatIterator.empty();
            }
            case 1: {
                return FloatIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(float @NotNull [] array) {
        FloatArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(float @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            float tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(float @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(float @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static FloatOption find(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        for (float e : array) {
            if (!predicate.test(e)) continue;
            return FloatOption.some(e);
        }
        return FloatOption.none();
    }

    public static float first(float @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static float last(float @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(float @NotNull [] array, float value) {
        for (float o : array) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(float @NotNull [] array, float @NotNull [] values) {
        for (float value : values) {
            if (FloatArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(float @NotNull [] array, @NotNull FloatTraversable values) {
        FloatIterator it = values.iterator();
        while (it.hasNext()) {
            float value = it.nextFloat();
            if (FloatArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        for (float e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        for (float e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        for (float e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(float @NotNull [] array, float value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(float @NotNull [] array, float value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(float @NotNull [] array, @NotNull FloatPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(float @NotNull [] array, float value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(float @NotNull [] array, float value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (Float.floatToIntBits(value) != Float.floatToIntBits(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(float @NotNull [] array, @NotNull FloatPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(float @NotNull [] array, @NotNull FloatPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static float max(float @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        float e = array[0];
        for (int i = 1; i < length; ++i) {
            float v = array[i];
            if (Float.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Float maxOrNull(float @NotNull [] array) {
        return array.length != 0 ? Float.valueOf(FloatArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static FloatOption maxOption(float @NotNull [] array) {
        return array.length != 0 ? FloatOption.some(FloatArrays.max(array)) : FloatOption.none();
    }

    @Contract(pure=true)
    public static float min(float @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        float e = array[0];
        for (int i = 1; i < length; ++i) {
            float v = array[i];
            if (Float.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Float minOrNull(float @NotNull [] array) {
        return array.length != 0 ? Float.valueOf(FloatArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static FloatOption minOption(float @NotNull [] array) {
        return array.length != 0 ? FloatOption.some(FloatArrays.min(array)) : FloatOption.none();
    }

    @Contract(pure=true)
    public static float fold(float @NotNull [] array, float zero, @NotNull FloatBinaryOperator op) {
        return FloatArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static float foldLeft(float @NotNull [] array, float zero, @NotNull FloatBinaryOperator op) {
        for (float e : array) {
            zero = op.applyAsFloat(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(float @NotNull [] array, U zero, @NotNull ObjFloatBiFunction<U, U> op) {
        for (float e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static float foldRight(float @NotNull [] array, float zero, @NotNull FloatBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsFloat(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(float @NotNull [] array, U zero, @NotNull FloatObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static float reduce(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return FloatArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static FloatOption reduceOption(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return FloatArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static float reduceLeft(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        float e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsFloat(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Float reduceLeftOrNull(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return array.length != 0 ? Float.valueOf(FloatArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static FloatOption reduceLeftOption(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return array.length != 0 ? FloatOption.some(FloatArrays.reduceLeft(array, op)) : FloatOption.none();
    }

    @Contract(pure=true)
    public static float reduceRight(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        float e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsFloat(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Float reduceRightOrNull(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return array.length != 0 ? Float.valueOf(FloatArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static FloatOption reduceRightOption(float @NotNull [] array, @NotNull FloatBinaryOperator op) {
        return array.length != 0 ? FloatOption.some(FloatArrays.reduceRight(array, op)) : FloatOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer) {
        return FloatArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return FloatArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(Float.valueOf(array[i])));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer, @NotNull FloatFunction<? extends CharSequence> transform) {
        return FloatArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull FloatFunction<? extends CharSequence> transform) {
        return FloatArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(float @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull FloatFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(float @NotNull [] array) {
        return FloatArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(float @NotNull [] array, CharSequence separator) {
        return FloatArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(float @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return FloatArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(float @NotNull [] array, @NotNull FloatFunction<? extends CharSequence> transform) {
        return FloatArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(float @NotNull [] array, CharSequence separator, @NotNull FloatFunction<? extends CharSequence> transform) {
        return FloatArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(float @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull FloatFunction<? extends CharSequence> transform) {
        return FloatArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractFloatIterator {
        private final float @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(float @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public float nextFloat() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractFloatIterator {
        private final float @NotNull [] array;
        private int index;

        ReverseItr(float @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(float @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public float nextFloat() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

