/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import org.jetbrains.annotations.NotNull;

final class IntIterators {
    static final IntIterator EMPTY = new AbstractIntIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "IntIterator[]";
        }
    };

    IntIterators() {
    }

    static final class Filter
    extends AbstractIntIterator {
        @NotNull
        private final IntIterator source;
        @NotNull
        private final IntPredicate predicate;
        private int nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull IntIterator source, @NotNull IntPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            int v = this.source.nextInt();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextInt();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractIntIterator {
        @NotNull
        private final IntIterator source;
        private final int value;
        private boolean flag = true;

        Appended(@NotNull IntIterator source, int value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public int nextInt() {
            if (this.source.hasNext()) {
                return this.source.nextInt();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractIntIterator {
        @NotNull
        private final IntIterator source;
        private final int value;
        private boolean flag = true;

        Prepended(@NotNull IntIterator source, int value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public int nextInt() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextInt();
        }
    }

    static final class Updated
    extends AbstractIntIterator {
        @NotNull
        private final IntIterator source;
        private final int n;
        private final int newValue;
        private int idx = 0;

        Updated(@NotNull IntIterator source, int n, int newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public int nextInt() {
            if (this.idx++ == this.n) {
                this.source.nextInt();
                return this.newValue;
            }
            return this.source.nextInt();
        }
    }

    static final class TakeWhile
    extends AbstractIntIterator {
        @NotNull
        private IntIterator source;
        private IntPredicate predicate;
        private int nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull IntIterator source, IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextInt();
                int v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractIntIterator {
        private final IntIterator source;
        private int n;

        Take(IntIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextInt();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractIntIterator {
        @NotNull
        private final Iterator<? extends IntIterator> iterators;
        private IntIterator current = null;

        ConcatAll(@NotNull Iterator<? extends IntIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextInt();
        }
    }

    static final class Concat
    extends AbstractIntIterator {
        private IntIterator it1;
        private IntIterator it2;

        Concat(IntIterator it1, IntIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextInt();
            }
            if (this.it2 != null) {
                return this.it2.nextInt();
            }
            throw new AssertionError();
        }
    }
}

