/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import kala.collection.base.Growable;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongGrowable;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.PrimitiveTraversable;
import kala.control.primitive.LongOption;
import kala.function.CheckedLongConsumer;
import kala.function.LongObjBiFunction;
import kala.function.ObjLongBiFunction;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LongTraversable
extends PrimitiveTraversable<Long> {
    @Override
    @NotNull
    public LongIterator iterator();

    @NotNull
    default public Spliterator.OfLong spliterator() {
        int ks = this.knownSize();
        if (ks == 0) {
            return Spliterators.emptyLongSpliterator();
        }
        if (ks > 0) {
            return Spliterators.spliterator(this.iterator(), (long)ks, this.characteristics());
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), this.characteristics());
    }

    @NotNull
    default public LongStream stream() {
        return StreamSupport.longStream(this.spliterator(), false);
    }

    @NotNull
    default public LongStream parallelStream() {
        return StreamSupport.longStream(this.spliterator(), true);
    }

    default public long elementAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && index >= knownSize) {
            throw new IndexOutOfBoundsException();
        }
        LongIterator it = this.iterator();
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            it.nextLong();
        }
        if (it.hasNext()) {
            return it.nextLong();
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    @NotNull
    default public LongOption find(@NotNull LongPredicate predicate) {
        return this.iterator().find(predicate);
    }

    default public boolean contains(long value) {
        return this.knownSize() != 0 && this.iterator().contains(value);
    }

    default public boolean containsAll(long @NotNull [] values) {
        return this.iterator().containsAll(values);
    }

    default public boolean containsAll(@NotNull LongTraversable values) {
        LongIterator it = values.iterator();
        if (this.knownSize() == 0) {
            return !it.hasNext();
        }
        while (it.hasNext()) {
            if (this.contains(it.nextLong())) continue;
            return false;
        }
        return true;
    }

    default public boolean sameElements(@NotNull LongTraversable other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean sameElements(@NotNull Iterable<?> other) {
        return this.iterator().sameElements(other.iterator());
    }

    default public boolean anyMatch(@NotNull LongPredicate predicate) {
        return this.iterator().anyMatch(predicate);
    }

    default public boolean allMatch(@NotNull LongPredicate predicate) {
        return this.iterator().allMatch(predicate);
    }

    default public boolean noneMatch(@NotNull LongPredicate predicate) {
        return this.iterator().noneMatch(predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G filterTo(@NotNull G destination, @NotNull LongPredicate predicate) {
        return this.iterator().filterTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G filterNotTo(@NotNull G destination, @NotNull LongPredicate predicate) {
        return this.iterator().filterNotTo(destination, predicate);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends LongGrowable> G mapTo(@NotNull G destination, @NotNull LongUnaryOperator mapper) {
        return this.iterator().mapTo(destination, mapper);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull LongFunction<? extends U> mapper) {
        return this.iterator().mapToObjTo(destination, mapper);
    }

    default public int count(@NotNull LongPredicate predicate) {
        return this.iterator().count(predicate);
    }

    default public long max() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().max();
    }

    @Override
    @Nullable
    default public Long maxOrNull() {
        return this.isNotEmpty() ? Long.valueOf(this.max()) : null;
    }

    @NotNull
    default public LongOption maxOption() {
        return this.knownSize() == 0 ? LongOption.none() : this.iterator().maxOption();
    }

    default public long min() {
        if (this.knownSize() == 0) {
            throw new NoSuchElementException();
        }
        return this.iterator().min();
    }

    @Override
    @Nullable
    default public Long minOrNull() {
        return this.knownSize() == 0 ? null : this.iterator().minOrNull();
    }

    @NotNull
    default public LongOption minOption() {
        return this.knownSize() == 0 ? LongOption.none() : this.iterator().minOption();
    }

    default public long fold(long zero, @NotNull LongBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public long foldLeft(long zero, @NotNull LongBinaryOperator op) {
        return this.iterator().foldLeft(zero, op);
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjLongBiFunction<U, U> op) {
        return this.iterator().foldLeftToObj(zero, op);
    }

    default public long foldRight(long zero, @NotNull LongBinaryOperator op) {
        return this.iterator().foldRight(zero, op);
    }

    default public <U> U foldRightToObj(U zero, @NotNull LongObjBiFunction<U, U> op) {
        return this.iterator().foldRightToObj(zero, op);
    }

    default public long reduce(@NotNull LongBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Long reduceOrNull(@NotNull LongBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public LongOption reduceOption(@NotNull LongBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public long reduceLeft(@NotNull LongBinaryOperator op) {
        return this.iterator().reduceLeft(op);
    }

    @Nullable
    default public Long reduceLeftOrNull(@NotNull LongBinaryOperator op) {
        return this.isNotEmpty() ? Long.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public LongOption reduceLeftOption(@NotNull LongBinaryOperator op) {
        return this.isNotEmpty() ? LongOption.some(this.reduceLeft(op)) : LongOption.none();
    }

    default public long reduceRight(@NotNull LongBinaryOperator op) {
        return this.iterator().reduceRight(op);
    }

    @Nullable
    default public Long reduceRightOrNull(@NotNull LongBinaryOperator op) {
        return this.isNotEmpty() ? Long.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public LongOption reduceRightOption(@NotNull LongBinaryOperator op) {
        return this.isNotEmpty() ? LongOption.some(this.reduceRight(op)) : LongOption.none();
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(long @NotNull [] dest) {
        return this.copyToArray(0, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(long @NotNull [] dest, int destPos) {
        return this.copyToArray(0, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param1")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(long @NotNull [] dest, int destPos, int limit) {
        return this.copyToArray(0, dest, destPos, limit);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, long @NotNull [] dest) {
        return this.copyToArray(srcPos, dest, 0, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, long @NotNull [] dest, int destPos) {
        return this.copyToArray(srcPos, dest, destPos, Integer.MAX_VALUE);
    }

    @Contract(mutates="param2")
    @Flow(sourceIsContainer=true, target="dest", targetIsContainer=true)
    default public int copyToArray(int srcPos, long @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + srcPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        if (limit <= 0) {
            return 0;
        }
        int dl = dest.length;
        if (destPos > dl) {
            return 0;
        }
        int kn = this.knownSize();
        if (kn >= 0 && srcPos >= kn) {
            return 0;
        }
        int end = Math.min(dl - destPos, limit) + destPos;
        int n = 0;
        LongIterator it = this.iterator();
        while (n++ < srcPos) {
            if (it.hasNext()) {
                it.nextLong();
                continue;
            }
            return 0;
        }
        int idx = destPos;
        while (it.hasNext() && idx < end) {
            dest[idx++] = it.nextLong();
        }
        return idx - destPos;
    }

    default public long @NotNull [] toArray() {
        int s = this.knownSize();
        if (s == 0) {
            return LongArrays.EMPTY;
        }
        if (s > 0) {
            long[] arr = new long[s];
            int i = 0;
            LongIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                long t = iterator.nextLong();
                arr[i++] = t;
            }
            return arr;
        }
        return this.iterator().toArray();
    }

    default public void forEach(@NotNull LongConsumer action) {
        this.iterator().forEach(action);
    }

    default public <Ex extends Throwable> void forEachChecked(@NotNull CheckedLongConsumer<Ex> action) throws Ex {
        this.forEach(action);
    }

    default public void forEachUnchecked(@NotNull CheckedLongConsumer<?> action) {
        this.forEach(action);
    }

    default public void forEachBreakable(@NotNull LongPredicate action) {
        Objects.requireNonNull(action);
        LongIterator it = this.iterator();
        while (it.hasNext() && action.test(it.nextLong())) {
        }
    }
}

