/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import kala.collection.base.Iterators;
import kala.control.AnyOption;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PrimitiveIterator<T, T_CONSUMER>
extends java.util.PrimitiveIterator<T, T_CONSUMER> {
    @Override
    public boolean hasNext();

    @Override
    @NotNull
    public T next();

    public void nextIgnoreResult();

    default public boolean isEmpty() {
        return !this.hasNext();
    }

    @Contract(mutates="this")
    default public int size() {
        int i = 0;
        while (this.hasNext()) {
            this.nextIgnoreResult();
            ++i;
        }
        return i;
    }

    default public int knownSize() {
        return this.hasNext() ? -1 : 0;
    }

    @Contract(mutates="this")
    public boolean contains(Object var1);

    @Contract(mutates="this")
    default public boolean containsAll(T @NotNull [] values) {
        for (T value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Contract(mutates="this")
    default public boolean containsAll(@NotNull Iterable<?> values) {
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean sameElements(@NotNull Iterator<?> var1);

    @NotNull
    public PrimitiveIterator<T, T_CONSUMER> drop(int var1);

    @NotNull
    public PrimitiveIterator<T, T_CONSUMER> take(int var1);

    @Nullable
    public T maxOrNull();

    @NotNull
    public AnyOption<T> maxOption();

    @Nullable
    public T minOrNull();

    @NotNull
    public AnyOption<T> minOption();

    @Contract(mutates="this")
    @NotNull
    public Object toArray();

    @Contract(mutates="this")
    public void forEach(@NotNull T_CONSUMER var1);

    @Override
    default public void forEachRemaining(@NotNull T_CONSUMER action) {
        this.forEach(action);
    }

    @Contract(mutates="this, param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer) {
        return this.joinTo(buffer, ", ");
    }

    @Contract(mutates="this, param1")
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator) {
        return this.joinTo(buffer, separator, "", "");
    }

    @Contract(value="_, _, _, _ -> param1", mutates="this, param1")
    @NotNull
    public <A extends Appendable> A joinTo(@NotNull A var1, CharSequence var2, CharSequence var3, CharSequence var4);

    @Contract(mutates="this")
    @NotNull
    default public String joinToString() {
        return this.joinTo(new StringBuilder()).toString();
    }

    @Contract(mutates="this")
    @NotNull
    default public String joinToString(CharSequence separator) {
        return this.joinTo(new StringBuilder(), separator).toString();
    }

    @Contract(mutates="this")
    @NotNull
    default public String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return this.joinTo(new StringBuilder(), separator, prefix, postfix).toString();
    }

    default public int hash() {
        return Iterators.hash(this);
    }
}

