/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kala.collection.base.AnyTraversable;
import kala.collection.base.Traversable;
import kala.collection.factory.Factory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface CollectionFactory<E, Builder, R>
extends Factory<Builder, R>,
Collector<E, Builder, R> {
    public static <E, Builder, R> CollectionFactory<E, Builder, R> narrow(CollectionFactory<E, Builder, ? extends R> factory) {
        return factory;
    }

    @Contract(pure=true)
    @NotNull
    public static <E, Builder, R> CollectionFactory<E, Builder, R> ofCollector(final @NotNull Collector<E, Builder, R> collector) {
        Objects.requireNonNull(collector);
        if (collector instanceof CollectionFactory) {
            return (CollectionFactory)collector;
        }
        return new CollectionFactory<E, Builder, R>(){

            @Override
            public Builder newBuilder() {
                return collector.supplier().get();
            }

            @Override
            public R build(@NotNull Builder builder) {
                return collector.finisher().apply(builder);
            }

            @Override
            public void addToBuilder(@NotNull Builder builder, E value) {
                collector.accumulator().accept(builder, value);
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return collector.combiner().apply(builder1, builder2);
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return collector.characteristics();
            }
        };
    }

    @Override
    public Builder newBuilder();

    @Override
    public R build(Builder var1);

    public void addToBuilder(@NotNull Builder var1, E var2);

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        for (E value : values) {
            this.addToBuilder(builder, value);
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull Iterator<? extends E> it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.next());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, E @NotNull [] values) {
        Objects.requireNonNull(values);
        for (E value : values) {
            this.addToBuilder(builder, value);
        }
    }

    public Builder mergeBuilder(@NotNull Builder var1, @NotNull Builder var2);

    default public void sizeHint(@NotNull Builder builder, int size) {
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Iterable<?> it) {
        this.sizeHint(builder, it, 0);
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Iterable<?> it, int delta) {
        int ks;
        Objects.requireNonNull(it);
        if (it instanceof Collection) {
            int s = ((Collection)it).size();
            this.sizeHint(builder, s + delta);
        } else if (it instanceof AnyTraversable && (ks = ((AnyTraversable)((Object)it)).knownSize()) >= 0) {
            this.sizeHint(builder, ks + delta);
        }
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull AnyTraversable<?> it) {
        this.sizeHint(builder, it, 0);
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull AnyTraversable<?> it, int delta) {
        Objects.requireNonNull(it);
        int ks = it.knownSize();
        if (ks >= 0) {
            this.sizeHint(builder, ks + delta);
        }
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Traversable<?> it) {
        this.sizeHint(builder, it, 0);
    }

    default public void sizeHint(@NotNull Builder builder, @NotNull Traversable<?> it, int delta) {
        this.sizeHint(builder, (AnyTraversable<?>)it, delta);
    }

    default public R empty() {
        return this.build(this.newBuilder());
    }

    default public R from(E @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull Iterable<? extends E> values) {
        Iterator<E> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, iterator);
        return this.build(builder);
    }

    default public R from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    default public R fill(int n, E value) {
        if (n <= 0) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder(builder, value);
        }
        return this.build(builder);
    }

    default public R fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder(builder, supplier.get());
        }
        return this.build(builder);
    }

    default public R fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return this.empty();
        }
        Builder builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder(builder, init.apply(i));
        }
        return this.build(builder);
    }

    @NotNull
    default public <U> CollectionFactory<E, Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        final CollectionFactory self = this;
        return new CollectionFactory<E, Builder, U>(){

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(@NotNull Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public void addToBuilder(@NotNull Builder builder, E value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }

            @Override
            public void sizeHint(@NotNull Builder builder, int size) {
                self.sizeHint(builder, size);
            }
        };
    }

    @Override
    default public Supplier<Builder> supplier() {
        return this::newBuilder;
    }

    @Override
    default public BiConsumer<Builder, E> accumulator() {
        return this::addToBuilder;
    }

    @Override
    default public Function<Builder, R> finisher() {
        return this::build;
    }

    @Override
    default public BinaryOperator<Builder> combiner() {
        return this::mergeBuilder;
    }

    @Override
    default public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

