/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongSupplier;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import org.jetbrains.annotations.NotNull;

public interface LongCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Long, Builder, R> {
    public static <Builder, R> LongCollectionFactory<Builder, R> narrow(LongCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, long var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Long value) {
        this.addToBuilder(builder, (long)value);
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull LongTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull LongIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextLong());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, long @NotNull [] values) {
        Objects.requireNonNull(values);
        for (long value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, long value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, LongSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsLong());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Long value) {
        return this.fill(n, (long)value);
    }

    default public R from(long @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull LongTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull LongIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> LongCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final LongCollectionFactory self = this;
        return new LongCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, long value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

