/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.CharComparators;
import kala.comparator.primitive.PrimitiveComparator;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CharComparator
extends PrimitiveComparator<Character, CharComparator> {
    @NotNull
    public static CharComparator naturalOrder() {
        return CharComparators.NaturalOrderComparator.INSTANCE;
    }

    @NotNull
    public static CharComparator reverseOrder() {
        return CharComparators.ReverseOrderComparator.INSTANCE;
    }

    @Override
    public int compare(char var1, char var2);

    @Override
    default public int compare(Character c1, Character c2) {
        return this.compare(c1.charValue(), c2.charValue());
    }

    @Override
    @NotNull
    default public CharComparator nullsFirst() {
        return new CharComparators.NullComparator(true, this);
    }

    @Override
    @NotNull
    default public CharComparator nullsLast() {
        return new CharComparators.NullComparator(false, this);
    }

    @Override
    @NotNull
    default public CharComparator reversed() {
        return (CharComparator & Serializable)(c1, c2) -> this.compare(c2, c1);
    }
}

