/*
 * Decompiled with CFR 0.152.
 */
package kala.comparator.primitive;

import java.io.Serializable;
import kala.comparator.primitive.LongComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LongComparators {
    LongComparators() {
    }

    static final class ReverseOrderNullComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final ReverseOrderNullComparator NULLS_FIRST = new ReverseOrderNullComparator(true);
        static final ReverseOrderNullComparator NULLS_LAST = new ReverseOrderNullComparator(false);
        private final boolean nullFirst;

        ReverseOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(long l1, long l2) {
            return Long.compare(l2, l1);
        }

        @Override
        public int compare(Long l1, Long l2) {
            if (l1 == null) {
                return l2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (l2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return l2.compareTo(l1);
        }

        @Override
        @NotNull
        public LongComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public LongComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public LongComparator reversed() {
            return this.nullFirst ? NaturalOrderNullComparator.NULLS_LAST : NaturalOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NaturalOrderNullComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        static final NaturalOrderNullComparator NULLS_FIRST = new NaturalOrderNullComparator(true);
        static final NaturalOrderNullComparator NULLS_LAST = new NaturalOrderNullComparator(false);
        private final boolean nullFirst;

        NaturalOrderNullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(long l1, long b2) {
            return Long.compare(l1, b2);
        }

        @Override
        public int compare(Long l1, Long b2) {
            if (l1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return l1.compareTo(b2);
        }

        @Override
        @NotNull
        public LongComparator nullsFirst() {
            return NULLS_FIRST;
        }

        @Override
        @NotNull
        public LongComparator nullsLast() {
            return NULLS_LAST;
        }

        @Override
        @NotNull
        public LongComparator reversed() {
            return this.nullFirst ? ReverseOrderNullComparator.NULLS_LAST : ReverseOrderNullComparator.NULLS_FIRST;
        }

        private Object readResolve() {
            return this.nullFirst ? NULLS_FIRST : NULLS_LAST;
        }
    }

    static final class NullComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final boolean nullFirst;
        @NotNull
        private final LongComparator real;

        NullComparator(boolean nullFirst, @NotNull LongComparator real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(long l1, long b2) {
            return this.real.compare(l1, b2);
        }

        @Override
        public int compare(@Nullable Long l1, @Nullable Long b2) {
            if (l1 == null) {
                return b2 == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real.compare(l1, b2);
        }

        @Override
        @NotNull
        public LongComparator nullsFirst() {
            return this.nullFirst ? this : new NullComparator(true, this.real);
        }

        @Override
        @NotNull
        public LongComparator nullsLast() {
            return this.nullFirst ? new NullComparator(false, this.real) : this;
        }

        @Override
        @NotNull
        public LongComparator reversed() {
            return new NullComparator(!this.nullFirst, this.real.reversed());
        }
    }

    static enum ReverseOrderComparator implements LongComparator
    {
        INSTANCE;


        @Override
        public final int compare(long l1, long b2) {
            return Long.compare(b2, l1);
        }

        @Override
        @NotNull
        public final LongComparator nullsFirst() {
            return ReverseOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final LongComparator nullsLast() {
            return ReverseOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final LongComparator reversed() {
            return NaturalOrderComparator.INSTANCE;
        }
    }

    static enum NaturalOrderComparator implements LongComparator
    {
        INSTANCE;


        @Override
        public final int compare(long l1, long b2) {
            return Long.compare(l1, b2);
        }

        @Override
        @NotNull
        public final LongComparator nullsFirst() {
            return NaturalOrderNullComparator.NULLS_FIRST;
        }

        @Override
        @NotNull
        public final LongComparator nullsLast() {
            return NaturalOrderNullComparator.NULLS_LAST;
        }

        @Override
        @NotNull
        public final LongComparator reversed() {
            return ReverseOrderComparator.INSTANCE;
        }
    }
}

