/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.control.AnyTry;
import kala.control.Try;
import kala.control.primitive.BooleanOption;
import kala.function.CheckedBooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BooleanTry
extends AnyTry<Boolean>
implements BooleanTraversable,
Serializable {
    private static final long serialVersionUID = 8279218383491584792L;
    public static final BooleanTry True = new BooleanTry(null);
    public static final BooleanTry False = new BooleanTry(null);
    private final Throwable cause;

    private BooleanTry(Throwable cause) {
        this.cause = cause;
    }

    @NotNull
    public static BooleanTry success(boolean value) {
        return value ? True : False;
    }

    @NotNull
    public static BooleanTry failure(@NotNull Throwable exception) {
        Objects.requireNonNull(exception);
        return new BooleanTry(exception);
    }

    @NotNull
    public static BooleanTry of(@NotNull CheckedBooleanSupplier<?> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return BooleanTry.success(supplier.getAsBooleanChecked());
        }
        catch (Throwable ex) {
            return BooleanTry.failure(ex);
        }
    }

    @Override
    public boolean isSuccess() {
        return this.cause == null;
    }

    @Override
    public boolean isFailure() {
        return this.cause != null;
    }

    @Override
    @Deprecated
    @NotNull
    public Boolean getValue() {
        return this.get();
    }

    public boolean get() {
        if (this.isFailure()) {
            throw new NoSuchElementException();
        }
        return this == True;
    }

    @Override
    @Nullable
    public Boolean getOrNull() {
        return this.isSuccess() ? Boolean.valueOf(this.get()) : null;
    }

    public BooleanOption getOption() {
        return this.isSuccess() ? BooleanOption.some(this.get()) : BooleanOption.none();
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @NotNull
    public <Ex extends Throwable> BooleanTry rethrow() throws Ex {
        if (this.isFailure()) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public <Ex extends Throwable> BooleanTry rethrow(@NotNull Class<? extends Ex> type) throws Ex {
        if (type.isInstance(this.cause)) {
            throw this.cause;
        }
        return this;
    }

    @NotNull
    public BooleanTry rethrowFatal() {
        if (Try.isFatal(this.cause)) {
            Try.sneakyThrow(this.cause);
        }
        return this;
    }

    @Override
    @NotNull
    public BooleanIterator iterator() {
        return this.isSuccess() ? BooleanIterator.of(this.get()) : BooleanIterator.empty();
    }

    public int hashCode() {
        if (this.isSuccess()) {
            return Boolean.hashCode(this.get()) + 518848667;
        }
        return this.getCause().hashCode() + 1918688519;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTry)) {
            return false;
        }
        AnyTry other = (AnyTry)o;
        if (this.isSuccess() && other.isSuccess()) {
            return Boolean.valueOf(this.get()).equals(other.getValue());
        }
        if (this.isFailure() && other.isFailure()) {
            return this.getCause().equals(other.getCause());
        }
        return false;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "BooleanTry.Success[" + this.get() + "]";
        }
        return "BooleanTry.Failure[" + this.cause + "]";
    }

    private static final class Replaced
    implements Serializable {
        private static final long serialVersionUID = 8898176688746795097L;
        private final boolean value;

        Replaced(boolean value) {
            this.value = value;
        }

        private Object readResolve() {
            return this.value ? True : False;
        }
    }
}

