/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongOption
extends PrimitiveOption<Long>
implements LongTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final LongOption None = new LongOption();
    private final long value;

    private LongOption() {
        this.value = 0L;
    }

    private LongOption(long value) {
        this.value = value;
    }

    @NotNull
    public static LongOption some(long value) {
        return new LongOption(value);
    }

    @NotNull
    public static LongOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static LongOption of(long value) {
        return LongOption.some(value);
    }

    @Deprecated
    @NotNull
    public static LongOption of(@Nullable Long value) {
        return LongOption.ofNullable(value);
    }

    @NotNull
    public static LongOption ofNullable(@Nullable Long value) {
        return value == null ? None : LongOption.some(value);
    }

    @NotNull
    public static LongOption fromJava(@NotNull OptionalLong optional) {
        return optional.isPresent() ? LongOption.some(optional.getAsLong()) : LongOption.none();
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public long get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("LongOption.None");
        }
        return this.value;
    }

    @Nullable
    public Long getOrNull() {
        return this.isDefined() ? Long.valueOf(this.value) : null;
    }

    public long getOrDefault(long defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public long getOrElse(@NotNull LongSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsLong();
    }

    public <Ex extends Throwable> long getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> long getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LongOption) {
            return this != None && o != None && this.value == ((LongOption)o).value;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Long && this.value == (Long)v;
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Long.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "LongOption.None" : "LongOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        return this.isDefined() ? LongIterator.of(this.value) : LongIterator.empty();
    }

    @Override
    public void forEach(@NotNull LongConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Long.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Long value;

        Data(Long value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : LongOption.some(this.value);
        }
    }
}

