/*
 * Decompiled with CFR 0.152.
 */
package kala.control.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.control.Option;
import kala.control.primitive.PrimitiveOption;
import kala.function.ShortConsumer;
import kala.function.ShortSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShortOption
extends PrimitiveOption<Short>
implements ShortTraversable {
    private static final long serialVersionUID = -8990024629462620023L;
    public static final ShortOption None = new ShortOption();
    private final short value;

    private ShortOption() {
        this.value = 0;
    }

    private ShortOption(short value) {
        this.value = value;
    }

    @NotNull
    public static ShortOption some(short value) {
        return new ShortOption(value);
    }

    @NotNull
    public static ShortOption none() {
        return None;
    }

    @Deprecated
    @NotNull
    public static ShortOption of(short value) {
        return ShortOption.some(value);
    }

    @Deprecated
    @NotNull
    public static ShortOption of(@Nullable Short value) {
        return ShortOption.ofNullable(value);
    }

    @NotNull
    public static ShortOption ofNullable(@Nullable Short value) {
        return value == null ? None : ShortOption.some(value);
    }

    public boolean isDefined() {
        return this != None;
    }

    @Override
    public boolean isEmpty() {
        return this == None;
    }

    public short get() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ShortOption.None");
        }
        return this.value;
    }

    @Nullable
    public Short getOrNull() {
        return this.isDefined() ? Short.valueOf(this.value) : null;
    }

    public short getOrDefault(short defaultValue) {
        return this.isDefined() ? this.value : defaultValue;
    }

    public short getOrElse(@NotNull ShortSupplier supplier) {
        return this.isDefined() ? this.get() : supplier.getAsShort();
    }

    public <Ex extends Throwable> short getOrThrowException(@NotNull Ex exception) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(exception);
            throw exception;
        }
        return this.value;
    }

    public <Ex extends Throwable> short getOrThrow(@NotNull Supplier<? extends Ex> supplier) throws Ex {
        if (this.isEmpty()) {
            Objects.requireNonNull(supplier);
            throw (Throwable)supplier.get();
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShortOption) {
            return this != None && o != None && this.value == ((ShortOption)o).value;
        }
        if (o instanceof Option) {
            Option other = (Option)o;
            if (this.isEmpty()) {
                return other.isEmpty();
            }
            if (other.isEmpty()) {
                return false;
            }
            Object v = other.get();
            return v instanceof Short && this.value == (Short)v;
        }
        return false;
    }

    public int hashCode() {
        return this.isDefined() ? -818206074 + Short.hashCode(this.value) : 1937147281;
    }

    public String toString() {
        return this == None ? "ShortOption.None" : "ShortOption[" + this.value + "]";
    }

    @Override
    @NotNull
    public ShortIterator iterator() {
        return this.isDefined() ? ShortIterator.of(this.value) : ShortIterator.empty();
    }

    @Override
    public void forEach(@NotNull ShortConsumer action) {
        if (this.isDefined()) {
            action.accept(this.value);
        }
    }

    private Object writeReplace() {
        return new Data(this == None ? null : Short.valueOf(this.value));
    }

    private static final class Data
    implements Serializable {
        private static final long serialVersionUID = -2044232156734869349L;
        private final Short value;

        Data(Short value) {
            this.value = value;
        }

        Object readResolve() {
            return this.value == null ? None : ShortOption.some(this.value);
        }
    }
}

