/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import kala.control.Try;
import kala.function.CharConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CheckedCharConsumer<Ex extends Throwable>
extends CharConsumer {
    @Contract(value="_ -> param1", pure=true)
    public static <Ex extends Throwable> CheckedCharConsumer<Ex> of(CheckedCharConsumer<? extends Ex> consumer) {
        return consumer;
    }

    public void acceptChecked(char var1) throws Ex;

    @Override
    default public void accept(char value) {
        try {
            this.acceptChecked(value);
        }
        catch (Throwable e) {
            Try.sneakyThrow(e);
        }
    }

    @Deprecated
    @NotNull
    default public Try<Void> tryAccept(char value) {
        try {
            this.acceptChecked(value);
            return Try.VOID;
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }
}

