/*
 * Decompiled with CFR 0.152.
 */
package kala.function;

import java.io.Serializable;
import kala.function.Hasher;

@FunctionalInterface
public interface FloatHasher
extends Hasher<Float> {
    public static final FloatHasher DEFAULT = new Default();
    public static final FloatHasher RAW_BITS = new RawBits();
    public static final FloatHasher PRIMITIVE = new Primitive();

    public static FloatHasher defaultHasher() {
        return DEFAULT;
    }

    public static FloatHasher rawBitsHasher() {
        return RAW_BITS;
    }

    public static FloatHasher primitiveHasher() {
        return PRIMITIVE;
    }

    @Override
    public int hash(float var1);

    @Override
    default public boolean equals(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    @Override
    @Deprecated
    default public int hash(Float value) {
        return this.hash(value.floatValue());
    }

    @Override
    @Deprecated
    default public boolean equals(Float a, Float b) {
        return this.equals(a.floatValue(), b.floatValue());
    }

    public static final class Default
    implements FloatHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        @Override
        public int hash(float value) {
            return Float.hashCode(value);
        }

        private Object readResolve() {
            return DEFAULT;
        }

        public String toString() {
            return "FloatHasher.Default";
        }
    }

    public static final class RawBits
    implements FloatHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        RawBits() {
        }

        @Override
        public int hash(float value) {
            return Integer.hashCode(Float.floatToRawIntBits(value));
        }

        @Override
        public boolean equals(float a, float b) {
            return Float.floatToRawIntBits(a) == Float.floatToRawIntBits(b);
        }

        private Object readResolve() {
            return RAW_BITS;
        }

        public String toString() {
            return "FloatHasher.RawBits";
        }
    }

    public static final class Primitive
    implements FloatHasher,
    Serializable {
        private static final long serialVersionUID = 0L;

        Primitive() {
        }

        @Override
        public int hash(float value) {
            return Integer.hashCode(Float.floatToRawIntBits(value));
        }

        @Override
        public boolean equals(float a, float b) {
            return a == b;
        }

        private Object readResolve() {
            return PRIMITIVE;
        }

        public String toString() {
            return "FloatHasher.Primitive";
        }
    }
}

