/*
 * Decompiled with CFR 0.152.
 */
package kala.range;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kala.collection.base.AbstractIterator;
import kala.collection.base.Iterators;
import kala.collection.base.Traversable;
import kala.internal.ComparableUtils;
import kala.range.BoundType;
import kala.range.Range;
import kala.range.RangeType;
import org.jetbrains.annotations.NotNull;

public final class GenericRange<T>
extends Range<T>
implements Serializable {
    private static final long serialVersionUID = 4151410859736356449L;
    private static final int HASH_MAGIC = 1249967851;
    private static final GenericRange<?> EMPTY = new GenericRange<Object>(RangeType.EMPTY, null, null);
    private static final GenericRange<?> ALL = new GenericRange<Object>(RangeType.ALL, null, null);
    @NotNull
    private final RangeType type;
    private final T lowerBound;
    private final T upperBound;
    private final Comparator<? super T> comparator;

    private GenericRange(RangeType type, T lowerBound, T upperBound) {
        this(type, lowerBound, upperBound, null);
    }

    private GenericRange(RangeType type, T lowerBound, T upperBound, Comparator<? super T> comparator) {
        this.type = type;
        this.comparator = comparator;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NotNull
    public static <T> GenericRange<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> GenericRange<T> all() {
        return ALL;
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> is(T value) {
        return GenericRange.is(value, null);
    }

    @NotNull
    public static <T> GenericRange<T> is(T value, Comparator<? super T> comparator) {
        if (comparator == null && !(value instanceof Comparable)) {
            throw new IllegalArgumentException();
        }
        return new GenericRange<T>(RangeType.CLOSED, value, value, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> open(@NotNull T lowerBound, @NotNull T upperBound) {
        return GenericRange.open(lowerBound, upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> open(T lowerBound, T upperBound, Comparator<? super T> comparator) {
        if (ComparableUtils.compare(lowerBound, upperBound, comparator) >= 0) {
            throw new IllegalArgumentException("lowerBound should be less than upperBound");
        }
        return new GenericRange<T>(RangeType.OPEN, lowerBound, upperBound, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> closed(@NotNull T lowerBound, @NotNull T upperBound) {
        return GenericRange.closed(lowerBound, upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> closed(T lowerBound, T upperBound, Comparator<? super T> comparator) {
        if (ComparableUtils.compare(lowerBound, upperBound, comparator) > 0) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new GenericRange<T>(RangeType.CLOSED, lowerBound, upperBound, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> openClosed(@NotNull T lowerBound, @NotNull T upperBound) {
        return GenericRange.openClosed(lowerBound, upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> openClosed(T lowerBound, T upperBound, Comparator<? super T> comparator) {
        if (ComparableUtils.compare(lowerBound, upperBound, comparator) > 0) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new GenericRange<T>(RangeType.OPEN_CLOSED, lowerBound, upperBound, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> closedOpen(@NotNull T lowerBound, @NotNull T upperBound) {
        return GenericRange.closedOpen(lowerBound, upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> closedOpen(T lowerBound, T upperBound, Comparator<? super T> comparator) {
        if (ComparableUtils.compare(lowerBound, upperBound, comparator) > 0) {
            throw new IllegalArgumentException("lowerBound should be less than or equal to upperBound");
        }
        return new GenericRange<T>(RangeType.CLOSED_OPEN, lowerBound, upperBound, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> greaterThan(@NotNull T lowerBound) {
        return GenericRange.greaterThan(lowerBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> greaterThan(T lowerBound, Comparator<? super T> comparator) {
        if (comparator == null && !(lowerBound instanceof Comparable)) {
            throw new IllegalArgumentException();
        }
        return new GenericRange<T>(RangeType.GREATER_THAN, lowerBound, null, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> atLeast(@NotNull T lowerBound) {
        return GenericRange.atLeast(lowerBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> atLeast(T lowerBound, Comparator<? super T> comparator) {
        if (comparator == null && !(lowerBound instanceof Comparable)) {
            throw new IllegalArgumentException();
        }
        return new GenericRange<T>(RangeType.AT_LEAST, lowerBound, null, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> lessThan(@NotNull T upperBound) {
        return GenericRange.lessThan(upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> lessThan(T upperBound, Comparator<? super T> comparator) {
        if (comparator == null && !(upperBound instanceof Comparable)) {
            throw new IllegalArgumentException();
        }
        return new GenericRange<T>(RangeType.LESS_THAN, upperBound, null, comparator);
    }

    @NotNull
    public static <T extends Comparable<? super T>> GenericRange<T> atMost(@NotNull T upperBound) {
        return GenericRange.atMost(upperBound, null);
    }

    @NotNull
    public static <T> GenericRange<T> atMost(T upperBound, Comparator<? super T> comparator) {
        if (comparator == null && !(upperBound instanceof Comparable)) {
            throw new IllegalArgumentException();
        }
        return new GenericRange<T>(RangeType.AT_MOST, upperBound, null, comparator);
    }

    @Override
    @NotNull
    public RangeType getType() {
        return this.type;
    }

    public T getLowerBound() {
        if (!this.hasLowerBound()) {
            throw new UnsupportedOperationException();
        }
        return this.lowerBound;
    }

    public T getUpperBound() {
        if (!this.hasUpperBound()) {
            throw new UnsupportedOperationException();
        }
        return this.upperBound;
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    public boolean isEmpty() {
        if (this.type == RangeType.EMPTY) {
            return true;
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        if (lowerBoundType == BoundType.CLOSED && upperBoundType == BoundType.CLOSED || lowerBoundType == BoundType.INFINITY || upperBoundType == BoundType.INFINITY) {
            return false;
        }
        return ComparableUtils.compare(this.lowerBound, this.upperBound, this.comparator) == 0;
    }

    public boolean contains(T value) {
        if (this.type == RangeType.EMPTY) {
            return false;
        }
        if (this.type == RangeType.ALL) {
            return true;
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        switch (lowerBoundType) {
            case OPEN: {
                if (ComparableUtils.compare(this.lowerBound, value, this.comparator) < 0) break;
                return false;
            }
            case CLOSED: {
                if (ComparableUtils.compare(this.lowerBound, value, this.comparator) <= 0) break;
                return false;
            }
        }
        switch (upperBoundType) {
            case OPEN: {
                if (ComparableUtils.compare(this.upperBound, value, this.comparator) > 0) break;
                return false;
            }
            case CLOSED: {
                if (ComparableUtils.compare(this.upperBound, value, this.comparator) >= 0) break;
                return false;
            }
        }
        return true;
    }

    public WithStep<T> withStep(@NotNull UnaryOperator<T> step) {
        Objects.requireNonNull(step);
        if (this.getLowerBoundType() == BoundType.INFINITY) {
            throw new UnsupportedOperationException();
        }
        return new WithStep<T>(this, step);
    }

    public int hashCode() {
        int result = this.comparator == null ? Comparator.naturalOrder().hashCode() : this.comparator.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Objects.hashCode(this.lowerBound);
        result = result * 31 + Objects.hashCode(this.upperBound);
        return result + 1249967851;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericRange)) {
            return false;
        }
        GenericRange other = (GenericRange)o;
        return this.type == other.type && ComparableUtils.comparatorEquals(this.comparator, other.comparator) && Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
    }

    public String toString() {
        if (this == EMPTY) {
            return "GenericRange.Empty";
        }
        if (this == ALL) {
            return "GenericRange.All";
        }
        BoundType lowerBoundType = this.type.getLowerBoundType();
        BoundType upperBoundType = this.type.getUpperBoundType();
        StringBuilder res = new StringBuilder(32);
        res.append("GenericRange");
        switch (lowerBoundType) {
            case OPEN: {
                res.append('(').append(this.lowerBound);
                break;
            }
            case CLOSED: {
                res.append('[').append(this.lowerBound);
                break;
            }
            case INFINITY: {
                res.append("(-Infinity");
            }
        }
        res.append("..");
        switch (upperBoundType) {
            case OPEN: {
                res.append(this.upperBound).append(')');
                break;
            }
            case CLOSED: {
                res.append(this.upperBound).append(']');
                break;
            }
            case INFINITY: {
                res.append("+Infinity)");
            }
        }
        return res.toString();
    }

    public static final class WithStep<T>
    implements Traversable<T> {
        @NotNull
        private final GenericRange<T> range;
        @NotNull
        private final UnaryOperator<T> step;

        WithStep(@NotNull GenericRange<T> range, @NotNull UnaryOperator<T> step) {
            this.range = range;
            this.step = step;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            RangeType type = this.range.getType();
            if (type == RangeType.EMPTY) {
                return Iterators.empty();
            }
            BoundType lowerBoundType = type.getLowerBoundType();
            BoundType upperBoundType = type.getUpperBoundType();
            Object initialValue = this.range.getLowerBound();
            if (lowerBoundType == BoundType.OPEN) {
                initialValue = this.step.apply(initialValue);
            }
            return new Itr(this.step, initialValue);
        }

        @Override
        public void forEach(@NotNull Consumer<? super T> action) {
            Objects.requireNonNull(action);
            RangeType type = this.range.getType();
            if (type == RangeType.EMPTY) {
                return;
            }
            BoundType lowerBoundType = type.getLowerBoundType();
            BoundType upperBoundType = type.getUpperBoundType();
            T lowerBound = this.range.getLowerBound();
            T upperBound = this.range.getUpperBound();
            Object value = lowerBound;
            if (lowerBoundType == BoundType.OPEN) {
                value = this.step.apply(value);
            }
            switch (upperBoundType) {
                case OPEN: {
                    while (ComparableUtils.compare(value, upperBound) < 0) {
                        action.accept(value);
                        value = this.step.apply(value);
                    }
                    break;
                }
                case CLOSED: {
                    while (ComparableUtils.compare(value, upperBound) <= 0) {
                        action.accept(value);
                        value = this.step.apply(value);
                    }
                    break;
                }
                default: {
                    while (true) {
                        action.accept(value);
                        value = this.step.apply(value);
                    }
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WithStep)) {
                return false;
            }
            WithStep other = (WithStep)o;
            return this.range.equals(other.range) && this.step.equals(other.step);
        }

        public int hashCode() {
            return this.range.hashCode() * 31 + this.step.hashCode();
        }

        private final class Itr
        extends AbstractIterator<T> {
            private T value;
            @NotNull
            private final UnaryOperator<T> step;

            Itr(UnaryOperator<T> step, T initialValue) {
                this.value = initialValue;
                this.step = step;
            }

            @Override
            public boolean hasNext() {
                switch (WithStep.this.range.getType().getUpperBoundType()) {
                    case OPEN: {
                        return ComparableUtils.compare(this.value, WithStep.this.range.upperBound, WithStep.this.range.comparator) < 0;
                    }
                    case CLOSED: {
                        return ComparableUtils.compare(this.value, WithStep.this.range.upperBound, WithStep.this.range.comparator) <= 0;
                    }
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = this.value;
                this.value = this.step.apply(res);
                return res;
            }
        }
    }
}

