/*
 * Decompiled with CFR 0.152.
 */
package kala.value;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kala.collection.base.Iterators;
import kala.collection.base.Mappable;
import kala.collection.base.Traversable;
import kala.value.AnyValue;
import kala.value.DefaultValue;
import kala.value.DelegateMutableValue;
import kala.value.DelegateValue;
import kala.value.LazyValue;
import kala.value.MutableValue;
import org.jetbrains.annotations.NotNull;

public interface Value<T>
extends AnyValue<T>,
Traversable<T>,
Mappable<T>,
Supplier<T> {
    @NotNull
    public static <T> Value<T> of(T value) {
        return new DefaultValue<T>(value);
    }

    @NotNull
    public static <T> Value<T> by(@NotNull Supplier<? extends T> getter) {
        Objects.requireNonNull(getter);
        return new DelegateValue<T>(getter);
    }

    @NotNull
    public static <T> LazyValue<T> lazy(@NotNull Supplier<? extends T> getter) {
        return LazyValue.of(getter);
    }

    @Override
    public T get();

    @Override
    default public T getValue() {
        return this.get();
    }

    @Override
    @NotNull
    default public <U> Value<U> map(@NotNull Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return Value.by(() -> mapper.apply((T)this.get()));
    }

    @NotNull
    default public MutableValue<T> asMutable(@NotNull Consumer<? super T> setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableValue<T>(this, setter);
    }

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return Iterators.of(this.get());
    }

    @Override
    default public boolean isEmpty() {
        return false;
    }

    @Override
    default public int size() {
        return 1;
    }

    @Override
    default public int knownSize() {
        return 1;
    }

    @Override
    default public void forEach(@NotNull Consumer<? super T> action) {
        action.accept(this.get());
    }
}

