/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractDoubleValue;
import kala.value.primitive.DoubleValue;
import org.jetbrains.annotations.NotNull;

public class LazyDoubleValue
extends AbstractDoubleValue
implements DoubleTraversable,
DoubleValue,
DoubleSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient DoubleSupplier supplier;
    private transient double value;

    private LazyDoubleValue(DoubleSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyDoubleValue(double value) {
        this.value = value;
    }

    public static LazyDoubleValue of(@NotNull DoubleSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyDoubleValue(supplier);
    }

    public static LazyDoubleValue ofValue(double value) {
        return new LazyDoubleValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double get() {
        if (this.supplier != null) {
            LazyDoubleValue lazyDoubleValue = this;
            synchronized (lazyDoubleValue) {
                DoubleSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsDouble();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public double getAsDouble() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyDoubleValue map(@NotNull DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyDoubleValue.of(() -> mapper.applyAsDouble(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public DoubleIterator iterator() {
        return new AbstractDoubleIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyDoubleValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyDoubleValue[" + this.value + "]";
        }
        return "LazyDoubleValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readDouble();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.get());
    }
}

