/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.function.FloatFunction;
import kala.function.FloatSupplier;
import kala.function.FloatUnaryOperator;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractFloatValue;
import kala.value.primitive.FloatValue;
import org.jetbrains.annotations.NotNull;

public class LazyFloatValue
extends AbstractFloatValue
implements FloatTraversable,
FloatValue,
FloatSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient FloatSupplier supplier;
    private transient float value;

    private LazyFloatValue(FloatSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyFloatValue(float value) {
        this.value = value;
    }

    public static LazyFloatValue of(@NotNull FloatSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyFloatValue(supplier);
    }

    public static LazyFloatValue ofValue(float value) {
        return new LazyFloatValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float get() {
        if (this.supplier != null) {
            LazyFloatValue lazyFloatValue = this;
            synchronized (lazyFloatValue) {
                FloatSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsFloat();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public float getAsFloat() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyFloatValue map(@NotNull FloatUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyFloatValue.of(() -> mapper.applyAsFloat(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull FloatFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public FloatIterator iterator() {
        return new AbstractFloatIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyFloatValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyFloatValue[" + this.value + "]";
        }
        return "LazyFloatValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readFloat();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeFloat(this.get());
    }
}

