/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.function.Memoized;
import kala.value.LazyValue;
import kala.value.primitive.AbstractLongValue;
import kala.value.primitive.LongValue;
import org.jetbrains.annotations.NotNull;

public class LazyLongValue
extends AbstractLongValue
implements LongTraversable,
LongValue,
LongSupplier,
Memoized,
Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient LongSupplier supplier;
    private transient long value;

    private LazyLongValue(LongSupplier supplier) {
        this.supplier = supplier;
    }

    private LazyLongValue(long value) {
        this.value = value;
    }

    public static LazyLongValue of(@NotNull LongSupplier supplier) {
        Objects.requireNonNull(supplier);
        return new LazyLongValue(supplier);
    }

    public static LazyLongValue ofValue(long value) {
        return new LazyLongValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get() {
        if (this.supplier != null) {
            LazyLongValue lazyLongValue = this;
            synchronized (lazyLongValue) {
                LongSupplier s = this.supplier;
                if (s != null) {
                    this.value = s.getAsLong();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    @Override
    public long getAsLong() {
        return this.get();
    }

    public boolean isReady() {
        return this.supplier == null;
    }

    @Override
    @NotNull
    public LazyLongValue map(@NotNull LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LazyLongValue.of(() -> mapper.applyAsLong(this.get()));
    }

    public <U> LazyValue<U> mapToObj(@NotNull LongFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return LazyValue.of(() -> mapper.apply(this.get()));
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        return new AbstractLongIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return LazyLongValue.this.get();
            }
        };
    }

    @Override
    public String toString() {
        if (this.supplier == null) {
            return "LazyLongValue[" + this.value + "]";
        }
        return "LazyLongValue[<not computed>]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readLong();
        this.supplier = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.get());
    }
}

