/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.value.primitive.DefaultLongValue;
import kala.value.primitive.DelegateLongValue;
import kala.value.primitive.DelegateMutableLongValue;
import kala.value.primitive.LazyLongValue;
import kala.value.primitive.MutableLongValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface LongValue
extends PrimitiveValue<Long>,
LongTraversable,
LongSupplier {
    @NotNull
    public static LongValue of(long value) {
        return new DefaultLongValue(value);
    }

    @NotNull
    public static LongValue by(@NotNull LongSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateLongValue(getter);
    }

    @NotNull
    public static LazyLongValue lazy(@NotNull LongSupplier getter) {
        return LazyLongValue.of(getter);
    }

    public long get();

    @Override
    @Deprecated
    default public long getAsLong() {
        return this.get();
    }

    @Override
    @NotNull
    default public Long getValue() {
        return this.get();
    }

    @NotNull
    default public LongValue map(@NotNull LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return LongValue.by(() -> mapper.applyAsLong(this.get()));
    }

    @NotNull
    default public MutableLongValue asMutable(@NotNull LongConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableLongValue(this, setter);
    }

    @Override
    @NotNull
    default public LongIterator iterator() {
        return LongIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull LongConsumer action) {
        action.accept(this.get());
    }
}

