/*
 * Decompiled with CFR 0.152.
 */
package kala.value.primitive;

import java.util.Objects;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.function.ShortConsumer;
import kala.function.ShortSupplier;
import kala.function.ShortUnaryOperator;
import kala.value.primitive.DefaultShortValue;
import kala.value.primitive.DelegateMutableShortValue;
import kala.value.primitive.DelegateShortValue;
import kala.value.primitive.LazyShortValue;
import kala.value.primitive.MutableShortValue;
import kala.value.primitive.PrimitiveValue;
import org.jetbrains.annotations.NotNull;

public interface ShortValue
extends PrimitiveValue<Short>,
ShortTraversable,
ShortSupplier {
    @NotNull
    public static ShortValue of(short value) {
        return new DefaultShortValue(value);
    }

    @NotNull
    public static ShortValue by(@NotNull ShortSupplier getter) {
        Objects.requireNonNull(getter);
        return new DelegateShortValue(getter);
    }

    @NotNull
    public static LazyShortValue lazy(@NotNull ShortSupplier getter) {
        return LazyShortValue.of(getter);
    }

    public short get();

    @Override
    @Deprecated
    default public short getAsShort() {
        return this.get();
    }

    @Override
    @NotNull
    default public Short getValue() {
        return this.get();
    }

    @NotNull
    default public ShortValue map(@NotNull ShortUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return ShortValue.by(() -> mapper.applyAsShort(this.get()));
    }

    @NotNull
    default public MutableShortValue asMutable(@NotNull ShortConsumer setter) {
        Objects.requireNonNull(setter);
        return new DelegateMutableShortValue(this, setter);
    }

    @Override
    @NotNull
    default public ShortIterator iterator() {
        return ShortIterator.of(this.get());
    }

    @Override
    default public void forEach(@NotNull ShortConsumer action) {
        action.accept(this.get());
    }
}

