/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import kala.collection.base.AbstractIterator;
import kala.collection.base.AbstractMapIterator;
import kala.collection.base.MapIterator;
import org.jetbrains.annotations.NotNull;

public final class MapIterators {
    public static final MapIterator<?, ?> EMPTY = new MapIterator<Object, Object>(){

        @Override
        public Object nextKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    private MapIterators() {
    }

    public static final class MapValues<K, V, OldV>
    extends AbstractMapIterator<K, V> {
        @NotNull
        private final MapIterator<? extends K, ? extends OldV> source;
        @NotNull
        private final BiFunction<? super K, ? super OldV, ? extends V> mapper;
        private K k;

        public MapValues(@NotNull MapIterator<? extends K, ? extends OldV> source, @NotNull BiFunction<? super K, ? super OldV, ? extends V> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public K nextKey() {
            this.k = this.source.nextKey();
            return this.k;
        }

        @Override
        public V getValue() {
            return this.mapper.apply(this.k, this.source.getValue());
        }
    }

    public static final class ValuesIterator<V>
    extends AbstractIterator<V> {
        private final MapIterator<?, ? extends V> source;

        public ValuesIterator(MapIterator<?, ? extends V> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public V next() {
            this.source.nextKey();
            return this.source.getValue();
        }
    }

    public static final class KeysIterator<K>
    extends AbstractIterator<K> {
        private final MapIterator<? extends K, ?> source;

        public KeysIterator(MapIterator<? extends K, ?> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public K next() {
            return this.source.nextKey();
        }
    }

    public static final class Mapped<E, K, V>
    extends AbstractIterator<E> {
        @NotNull
        private final MapIterator<? extends K, ? extends V> source;
        @NotNull
        private final BiFunction<? super K, ? super V, ? extends E> mapper;

        public Mapped(@NotNull MapIterator<? extends K, ? extends V> source, @NotNull BiFunction<? super K, ? super V, ? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public E next() {
            return this.mapper.apply(this.source.nextKey(), this.source.getValue());
        }
    }

    public static final class OfIterator<K, V>
    extends AbstractMapIterator<K, V> {
        private final Iterator<? extends Map.Entry<? extends K, ? extends V>> source;
        private V value;

        public OfIterator(Iterator<? extends Map.Entry<? extends K, ? extends V>> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public K nextKey() {
            Map.Entry<K, V> n = this.source.next();
            this.value = n.getValue();
            return n.getKey();
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

