/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.base.AbstractIterator;
import kala.collection.base.GenericArrays;
import kala.collection.base.Growable;
import kala.collection.base.Iterators;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanGrowable;
import kala.collection.base.primitive.BooleanIterators;
import kala.collection.base.primitive.PrimitiveIterator;
import kala.control.primitive.BooleanOption;
import kala.function.BooleanBinaryOperator;
import kala.function.BooleanConsumer;
import kala.function.BooleanFunction;
import kala.function.BooleanObjBiFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import kala.function.ObjBooleanBiFunction;
import kala.internal.InternalBooleanArrayBuilder;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BooleanIterator
extends PrimitiveIterator<Boolean, BooleanConsumer> {
    @NotNull
    public static BooleanIterator empty() {
        return BooleanIterators.EMPTY;
    }

    @NotNull
    public static BooleanIterator of() {
        return BooleanIterator.empty();
    }

    @NotNull
    public static BooleanIterator of(final boolean value) {
        return new BooleanIterator(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public boolean nextBoolean() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return value;
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                if (this.hasNext) {
                    return "BooleanIterator[" + value + "]";
                }
                return "BooleanIterator[]";
            }
        };
    }

    @NotNull
    public static BooleanIterator of(boolean ... values) {
        return BooleanArrays.iterator(values);
    }

    @NotNull
    public static BooleanIterator ofIterator(final @NotNull @NotNull Iterator<? extends @NotNull Boolean> it) {
        Objects.requireNonNull(it);
        if (it instanceof BooleanIterator) {
            return (BooleanIterator)it;
        }
        return new BooleanIterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public boolean nextBoolean() {
                return (Boolean)it.next();
            }

            public String toString() {
                return it.toString();
            }
        };
    }

    @NotNull
    public static BooleanIterator concat(@NotNull BooleanIterator it1, @NotNull BooleanIterator it2) {
        if (!it1.hasNext()) {
            return Objects.requireNonNull(it2);
        }
        if (!it2.hasNext()) {
            return it1;
        }
        return new BooleanIterators.Concat(it1, it2);
    }

    @NotNull
    public static BooleanIterator concat(BooleanIterator ... its) {
        switch (its.length) {
            case 0: {
                return BooleanIterator.empty();
            }
            case 1: {
                return Objects.requireNonNull(its[0]);
            }
            case 2: {
                return BooleanIterator.concat(its[0], its[1]);
            }
        }
        return new BooleanIterators.ConcatAll(GenericArrays.iterator(its));
    }

    @NotNull
    public static BooleanIterator concat(@NotNull Iterable<? extends BooleanIterator> its) {
        return BooleanIterator.concat(its.iterator());
    }

    @NotNull
    public static BooleanIterator concat(@NotNull Iterator<? extends BooleanIterator> its) {
        if (!its.hasNext()) {
            return BooleanIterator.empty();
        }
        return new BooleanIterators.ConcatAll(its);
    }

    public boolean nextBoolean();

    @Override
    default public void nextIgnoreResult() {
        this.nextBoolean();
    }

    @Override
    @Deprecated
    @NotNull
    default public Boolean next() {
        return this.nextBoolean();
    }

    @NotNull
    default public BooleanOption find(@NotNull BooleanPredicate predicate) {
        while (this.hasNext()) {
            boolean value = this.nextBoolean();
            if (!predicate.test(value)) continue;
            return BooleanOption.some(value);
        }
        return BooleanOption.None;
    }

    default public boolean contains(boolean value) {
        while (this.hasNext()) {
            if (value != this.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean contains(Object value) {
        if (!(value instanceof Boolean)) {
            return false;
        }
        boolean v = (Boolean)value;
        while (this.hasNext()) {
            if (v != this.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(boolean @NotNull [] values) {
        if (!this.hasNext()) {
            return values.length == 0;
        }
        boolean containsTrue = false;
        boolean containsFalse = false;
        while (this.hasNext()) {
            boolean v = this.nextBoolean();
            if (v) {
                containsTrue = true;
            } else {
                containsFalse = true;
            }
            if (!containsTrue || !containsFalse) continue;
            return true;
        }
        if (containsTrue && containsFalse) {
            throw new AssertionError();
        }
        if (containsTrue) {
            for (boolean value : values) {
                if (value) continue;
                return false;
            }
        } else if (containsFalse) {
            for (boolean value : values) {
                if (!value) continue;
                return false;
            }
        } else {
            throw new AssertionError();
        }
        return true;
    }

    default public boolean containsAll(Boolean @NotNull [] values) {
        if (values.length == 0) {
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        boolean containsTrue = false;
        boolean containsFalse = false;
        while (this.hasNext()) {
            boolean v = this.nextBoolean();
            if (v) {
                containsTrue = true;
            } else {
                containsFalse = true;
            }
            if (!containsTrue || !containsFalse) continue;
            break;
        }
        if (containsTrue && containsFalse) {
            for (Boolean value : values) {
                if (value != null) continue;
                return false;
            }
        } else if (containsTrue) {
            for (Boolean value : values) {
                if (value != null && value.booleanValue()) continue;
                return false;
            }
        } else if (containsFalse) {
            for (Boolean value : values) {
                if (value != null && !value.booleanValue()) continue;
                return false;
            }
        } else {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    default public boolean containsAll(@NotNull Iterable<?> values) {
        Iterator<?> it = values.iterator();
        if (!it.hasNext()) {
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        boolean containsTrue = false;
        boolean containsFalse = false;
        while (this.hasNext()) {
            boolean v = this.nextBoolean();
            if (v) {
                containsTrue = true;
            } else {
                containsFalse = true;
            }
            if (!containsTrue || !containsFalse) continue;
            break;
        }
        if (containsTrue && containsFalse) {
            while (it.hasNext()) {
                Object value = it.next();
                if (value instanceof Boolean) continue;
                return false;
            }
        } else if (containsTrue) {
            while (it.hasNext()) {
                Object value = it.next();
                if (value instanceof Boolean && ((Boolean)value).booleanValue()) continue;
                return false;
            }
        } else if (containsFalse) {
            while (it.hasNext()) {
                Object value = it.next();
                if (value instanceof Boolean && !((Boolean)value).booleanValue()) continue;
                return false;
            }
        } else {
            throw new AssertionError();
        }
        return true;
    }

    default public boolean sameElements(@NotNull BooleanIterator other) {
        while (this.hasNext() && other.hasNext()) {
            if (this.nextBoolean() == other.nextBoolean()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    @Override
    default public boolean sameElements(@NotNull Iterator<?> other) {
        if (other instanceof BooleanIterator) {
            return this.sameElements((BooleanIterator)other);
        }
        while (this.hasNext() && other.hasNext()) {
            Object value = other.next();
            if (!(value instanceof Boolean)) {
                return false;
            }
            if (((Boolean)value).booleanValue() == this.nextBoolean()) continue;
            return false;
        }
        return this.hasNext() == other.hasNext();
    }

    default public boolean anyMatch(@NotNull BooleanPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextBoolean())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(@NotNull BooleanPredicate predicate) {
        while (this.hasNext()) {
            if (predicate.test(this.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(@NotNull BooleanPredicate predicate) {
        while (this.hasNext()) {
            if (!predicate.test(this.nextBoolean())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public BooleanIterator drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        while (n > 0 && this.hasNext()) {
            this.nextBoolean();
            --n;
        }
        return this;
    }

    @NotNull
    default public BooleanIterator dropWhile(@NotNull BooleanPredicate predicate) {
        if (!this.hasNext()) {
            return this;
        }
        boolean value = false;
        boolean p = false;
        while (this.hasNext()) {
            value = this.nextBoolean();
            if (predicate.test(value)) continue;
            p = true;
            break;
        }
        if (p) {
            return this.hasNext() ? this.prepended(value) : BooleanIterator.of(value);
        }
        return this;
    }

    @NotNull
    default public BooleanIterator take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext() || n == 0) {
            return BooleanIterator.empty();
        }
        return new BooleanIterators.Take(this, n);
    }

    @NotNull
    default public BooleanIterator takeWhile(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return this;
        }
        return new BooleanIterators.TakeWhile(this, predicate);
    }

    @NotNull
    default public BooleanIterator updated(int n, boolean newValue) {
        if (!this.hasNext() || n < 0) {
            return this;
        }
        if (n == 0) {
            this.nextBoolean();
            return this.prepended(newValue);
        }
        return new BooleanIterators.Updated(this, n, newValue);
    }

    @NotNull
    default public BooleanIterator prepended(boolean value) {
        return new BooleanIterators.Prepended(this, value);
    }

    @NotNull
    default public BooleanIterator appended(boolean value) {
        return new BooleanIterators.Appended(this, value);
    }

    @NotNull
    default public BooleanIterator filter(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return BooleanIterator.empty();
        }
        return new BooleanIterators.Filter(this, predicate, false);
    }

    @NotNull
    default public BooleanIterator filterNot(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (!this.hasNext()) {
            return BooleanIterator.empty();
        }
        return new BooleanIterators.Filter(this, predicate, true);
    }

    @NotNull
    default public BooleanIterator map(final @NotNull BooleanUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return this;
        }
        return new AbstractBooleanIterator(){

            @Override
            public boolean hasNext() {
                return BooleanIterator.this.hasNext();
            }

            @Override
            public boolean nextBoolean() {
                return mapper.applyAsBoolean(BooleanIterator.this.nextBoolean());
            }
        };
    }

    @NotNull
    default public <U> Iterator<U> mapToObj(final @NotNull BooleanFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.hasNext()) {
            return Iterators.empty();
        }
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return BooleanIterator.this.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(BooleanIterator.this.nextBoolean());
            }
        };
    }

    @NotNull
    default public @NotNull Tuple2<@NotNull BooleanIterator, @NotNull BooleanIterator> span(@NotNull BooleanPredicate predicate) {
        if (!this.hasNext()) {
            return Tuple.of(BooleanIterator.empty(), BooleanIterator.empty());
        }
        InternalBooleanArrayBuilder builder = new InternalBooleanArrayBuilder();
        BooleanIterator it = this;
        while (it.hasNext()) {
            boolean e = it.nextBoolean();
            if (predicate.test(e)) {
                builder.append(e);
                continue;
            }
            it = it.prepended(e);
            break;
        }
        return Tuple.of(builder.iterator(), it);
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G filterTo(@NotNull G destination, @NotNull BooleanPredicate predicate) {
        BooleanIterator it = this;
        while (it.hasNext()) {
            boolean e = it.nextBoolean();
            if (!predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G filterNotTo(@NotNull G destination, @NotNull BooleanPredicate predicate) {
        BooleanIterator it = this;
        while (it.hasNext()) {
            boolean e = it.nextBoolean();
            if (predicate.test(e)) continue;
            destination.plusAssign(e);
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <G extends BooleanGrowable> G mapTo(@NotNull G destination, @NotNull BooleanUnaryOperator mapper) {
        BooleanIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.applyAsBoolean(it.nextBoolean()));
        }
        return destination;
    }

    @Contract(value="_, _ -> param1", mutates="param1")
    @NotNull
    default public <U, G extends Growable<? super U>> G mapToObjTo(@NotNull G destination, @NotNull BooleanFunction<? extends U> mapper) {
        BooleanIterator it = this;
        while (it.hasNext()) {
            destination.plusAssign(mapper.apply(it.nextBoolean()));
        }
        return destination;
    }

    default public int count(@NotNull BooleanPredicate predicate) {
        int c = 0;
        while (this.hasNext()) {
            if (!predicate.test(this.nextBoolean())) continue;
            ++c;
        }
        return c;
    }

    default public boolean max() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.hasNext()) {
            if (!this.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    default public Boolean maxOrNull() {
        return this.hasNext() ? Boolean.valueOf(this.max()) : null;
    }

    @NotNull
    default public BooleanOption maxOption() {
        return this.hasNext() ? BooleanOption.some(this.max()) : BooleanOption.none();
    }

    default public boolean min() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.hasNext()) {
            if (this.nextBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    default public Boolean minOrNull() {
        return this.hasNext() ? Boolean.valueOf(this.min()) : null;
    }

    @NotNull
    default public BooleanOption minOption() {
        return this.hasNext() ? BooleanOption.some(this.min()) : BooleanOption.none();
    }

    default public boolean fold(boolean zero, @NotNull BooleanBinaryOperator op) {
        return this.foldLeft(zero, op);
    }

    default public boolean foldLeft(boolean zero, @NotNull BooleanBinaryOperator op) {
        while (this.hasNext()) {
            zero = op.applyAsBoolean(zero, this.nextBoolean());
        }
        return zero;
    }

    default public <U> U foldLeftToObj(U zero, @NotNull ObjBooleanBiFunction<U, U> op) {
        while (this.hasNext()) {
            zero = op.apply(zero, this.nextBoolean());
        }
        return zero;
    }

    default public boolean foldRight(boolean zero, @NotNull BooleanBinaryOperator op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalBooleanArrayBuilder builder = new InternalBooleanArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextBoolean());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.applyAsBoolean(builder.get(i), zero);
        }
        return zero;
    }

    default public <U> U foldRightToObj(U zero, @NotNull BooleanObjBiFunction<U, U> op) {
        if (!this.hasNext()) {
            return zero;
        }
        InternalBooleanArrayBuilder builder = new InternalBooleanArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextBoolean());
        }
        for (int i = builder.size() - 1; i >= 0; --i) {
            zero = op.apply(builder.get(i), zero);
        }
        return zero;
    }

    default public boolean reduce(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeft(op);
    }

    @Nullable
    default public Boolean reduceOrNull(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeftOrNull(op);
    }

    @NotNull
    default public BooleanOption reduceOption(@NotNull BooleanBinaryOperator op) {
        return this.reduceLeftOption(op);
    }

    default public boolean reduceLeft(@NotNull BooleanBinaryOperator op) {
        boolean e = this.nextBoolean();
        while (this.hasNext()) {
            e = op.applyAsBoolean(e, this.nextBoolean());
        }
        return e;
    }

    @Nullable
    default public Boolean reduceLeftOrNull(@NotNull BooleanBinaryOperator op) {
        return this.hasNext() ? Boolean.valueOf(this.reduceLeft(op)) : null;
    }

    @NotNull
    default public BooleanOption reduceLeftOption(@NotNull BooleanBinaryOperator op) {
        return this.hasNext() ? BooleanOption.some(this.reduceLeft(op)) : BooleanOption.none();
    }

    default public boolean reduceRight(@NotNull BooleanBinaryOperator op) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InternalBooleanArrayBuilder list = new InternalBooleanArrayBuilder();
        list.append(this.nextBoolean());
        while (this.hasNext()) {
            list.append(this.nextBoolean());
        }
        int size = list.size();
        boolean e = list.get(size - 1);
        for (int i = size - 2; i >= 0; --i) {
            e = op.applyAsBoolean(list.get(i), e);
        }
        return e;
    }

    @Nullable
    default public Boolean reduceRightOrNull(@NotNull BooleanBinaryOperator op) {
        return this.hasNext() ? Boolean.valueOf(this.reduceRight(op)) : null;
    }

    @NotNull
    default public BooleanOption reduceRightOption(@NotNull BooleanBinaryOperator op) {
        return this.hasNext() ? BooleanOption.some(this.reduceRight(op)) : BooleanOption.none();
    }

    default public boolean @NotNull [] toArray() {
        if (!this.hasNext()) {
            return BooleanArrays.EMPTY;
        }
        InternalBooleanArrayBuilder builder = new InternalBooleanArrayBuilder();
        while (this.hasNext()) {
            builder.append(this.nextBoolean());
        }
        return builder.toArray();
    }

    @Override
    default public void forEach(@NotNull BooleanConsumer action) {
        while (this.hasNext()) {
            action.accept(this.nextBoolean());
        }
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Boolean> action) {
        if (action instanceof BooleanConsumer) {
            this.forEach((BooleanConsumer)((Object)action));
        } else {
            this.forEach(action::accept);
        }
    }

    @Override
    default public void forEachRemaining(@NotNull BooleanConsumer action) {
        this.forEach(action);
    }

    @Override
    @NotNull
    default public <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        try {
            buffer.append(prefix);
            if (this.hasNext()) {
                buffer.append(String.valueOf(this.nextBoolean()));
            }
            while (this.hasNext()) {
                buffer.append(separator).append(String.valueOf(this.nextBoolean()));
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    @Override
    default public int hash() {
        int res = 0;
        while (this.hasNext()) {
            res = res * 31 + Boolean.hashCode(this.nextBoolean());
        }
        return res;
    }
}

