/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import kala.Conditions;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.control.primitive.ByteOption;
import kala.function.ByteBinaryOperator;
import kala.function.ByteFunction;
import kala.function.ByteObjBiFunction;
import kala.function.BytePredicate;
import kala.function.ObjByteBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteArrays {
    public static final byte[] EMPTY = new byte[0];
    private static final IntFunction<byte[]> GENERATOR = byte[]::new;

    private ByteArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<byte[]> generator() {
        return GENERATOR;
    }

    public static byte @NotNull [] create(int length) {
        return new byte[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static byte @NotNull [] of(byte ... values) {
        return values;
    }

    public static byte @NotNull [] from(byte @NotNull [] values) {
        return (byte[])values.clone();
    }

    public static byte @NotNull [] from(@NotNull ByteTraversable values) {
        return values.toArray();
    }

    public static byte @NotNull [] from(@NotNull ByteIterator it) {
        return it.toArray();
    }

    @NotNull
    public static String className(byte @NotNull [] array) {
        return "byte[]";
    }

    @NotNull
    public static ByteIterator iterator(byte @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return ByteIterator.empty();
            }
            case 1: {
                return ByteIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static ByteIterator iterator(byte @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return ByteIterator.empty();
            }
            case 1: {
                return ByteIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static ByteIterator iterator(byte @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return ByteIterator.empty();
            }
            case 1: {
                return ByteIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    public static boolean isEmpty(byte @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(byte @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(byte @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(byte @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static byte get(byte @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Byte getOrNull(byte @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Byte.valueOf(array[index]) : null;
    }

    @NotNull
    public static ByteOption getOption(byte @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? ByteOption.some(array[index]) : ByteOption.none();
    }

    public static void set(byte @NotNull [] array, int index, byte value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static byte @NotNull [] reversed(byte @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        byte[] res = new byte[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static ByteIterator reverseIterator(byte @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return ByteIterator.empty();
            }
            case 1: {
                return ByteIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(byte @NotNull [] array) {
        ByteArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(byte @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            byte tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(byte @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(byte @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static ByteOption find(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        for (byte e : array) {
            if (!predicate.test(e)) continue;
            return ByteOption.some(e);
        }
        return ByteOption.none();
    }

    public static byte first(byte @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static byte last(byte @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(byte @NotNull [] array, byte value) {
        for (byte o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(byte @NotNull [] array, byte @NotNull [] values) {
        for (byte value : values) {
            if (ByteArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(byte @NotNull [] array, @NotNull ByteTraversable values) {
        ByteIterator it = values.iterator();
        while (it.hasNext()) {
            byte value = it.nextByte();
            if (ByteArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        for (byte e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        for (byte e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        for (byte e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(byte @NotNull [] array, byte value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(byte @NotNull [] array, byte value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(byte @NotNull [] array, @NotNull BytePredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(byte @NotNull [] array, byte value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(byte @NotNull [] array, byte value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(byte @NotNull [] array, @NotNull BytePredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(byte @NotNull [] array, @NotNull BytePredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static byte max(byte @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        byte e = array[0];
        for (int i = 1; i < length; ++i) {
            byte v = array[i];
            if (Byte.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Byte maxOrNull(byte @NotNull [] array) {
        return array.length != 0 ? Byte.valueOf(ByteArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ByteOption maxOption(byte @NotNull [] array) {
        return array.length != 0 ? ByteOption.some(ByteArrays.max(array)) : ByteOption.none();
    }

    @Contract(pure=true)
    public static byte min(byte @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        byte e = array[0];
        for (int i = 1; i < length; ++i) {
            byte v = array[i];
            if (Byte.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Byte minOrNull(byte @NotNull [] array) {
        return array.length != 0 ? Byte.valueOf(ByteArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ByteOption minOption(byte @NotNull [] array) {
        return array.length != 0 ? ByteOption.some(ByteArrays.min(array)) : ByteOption.none();
    }

    @Contract(pure=true)
    public static byte fold(byte @NotNull [] array, byte zero, @NotNull ByteBinaryOperator op) {
        return ByteArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static byte foldLeft(byte @NotNull [] array, byte zero, @NotNull ByteBinaryOperator op) {
        for (byte e : array) {
            zero = op.applyAsByte(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(byte @NotNull [] array, U zero, @NotNull ObjByteBiFunction<U, U> op) {
        for (byte e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static byte foldRight(byte @NotNull [] array, byte zero, @NotNull ByteBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsByte(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(byte @NotNull [] array, U zero, @NotNull ByteObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static byte reduce(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return ByteArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static ByteOption reduceOption(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return ByteArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static byte reduceLeft(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        byte e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsByte(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Byte reduceLeftOrNull(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return array.length != 0 ? Byte.valueOf(ByteArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ByteOption reduceLeftOption(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return array.length != 0 ? ByteOption.some(ByteArrays.reduceLeft(array, op)) : ByteOption.none();
    }

    @Contract(pure=true)
    public static byte reduceRight(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        byte e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsByte(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Byte reduceRightOrNull(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return array.length != 0 ? Byte.valueOf(ByteArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static ByteOption reduceRightOption(byte @NotNull [] array, @NotNull ByteBinaryOperator op) {
        return array.length != 0 ? ByteOption.some(ByteArrays.reduceRight(array, op)) : ByteOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer) {
        return ByteArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return ByteArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer, @NotNull ByteFunction<? extends CharSequence> transform) {
        return ByteArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull ByteFunction<? extends CharSequence> transform) {
        return ByteArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(byte @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull ByteFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array) {
        return ByteArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array, CharSequence separator) {
        return ByteArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return ByteArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array, @NotNull ByteFunction<? extends CharSequence> transform) {
        return ByteArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array, CharSequence separator, @NotNull ByteFunction<? extends CharSequence> transform) {
        return ByteArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(byte @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull ByteFunction<? extends CharSequence> transform) {
        return ByteArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractByteIterator {
        private final byte @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(byte @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public byte nextByte() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractByteIterator {
        private final byte @NotNull [] array;
        private int index;

        ReverseItr(byte @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(byte @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public byte nextByte() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

