/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntBinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import kala.Conditions;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.control.primitive.IntOption;
import kala.function.IntObjBiFunction;
import kala.function.ObjIntBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntArrays {
    public static final int[] EMPTY = new int[0];
    private static final IntFunction<int[]> GENERATOR = int[]::new;

    private IntArrays() {
    }

    @Contract(pure=true)
    @NotNull
    public static IntFunction<int[]> generator() {
        return GENERATOR;
    }

    public static int @NotNull [] create(int length) {
        return new int[length];
    }

    @Contract(value="_ -> param1", pure=true)
    public static int @NotNull [] of(int ... values) {
        return values;
    }

    public static int @NotNull [] from(int @NotNull [] values) {
        return (int[])values.clone();
    }

    public static int @NotNull [] from(@NotNull IntTraversable values) {
        return values.toArray();
    }

    public static int @NotNull [] from(@NotNull IntIterator it) {
        return it.toArray();
    }

    public static int @NotNull [] from(@NotNull IntStream stream) {
        return stream.toArray();
    }

    @NotNull
    public static String className(int @NotNull [] array) {
        return "int[]";
    }

    @NotNull
    public static IntIterator iterator(int @NotNull [] array) {
        int arrayLength = array.length;
        switch (arrayLength) {
            case 0: {
                return IntIterator.empty();
            }
            case 1: {
                return IntIterator.of(array[0]);
            }
        }
        return new Itr(array, 0, arrayLength);
    }

    @NotNull
    public static IntIterator iterator(int @NotNull [] array, int beginIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndex(beginIndex, arrayLength);
        switch (arrayLength - beginIndex) {
            case 0: {
                return IntIterator.empty();
            }
            case 1: {
                return IntIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, arrayLength);
    }

    @NotNull
    public static IntIterator iterator(int @NotNull [] array, int beginIndex, int endIndex) {
        int arrayLength = array.length;
        Conditions.checkPositionIndices(beginIndex, endIndex, arrayLength);
        switch (endIndex - beginIndex) {
            case 0: {
                return IntIterator.empty();
            }
            case 1: {
                return IntIterator.of(array[beginIndex]);
            }
        }
        return new Itr(array, beginIndex, endIndex);
    }

    @NotNull
    public static Spliterator.OfInt spliterator(int @NotNull [] array) {
        return Arrays.spliterator(array);
    }

    @NotNull
    public static IntStream stream(int @NotNull [] array) {
        return Arrays.stream(array);
    }

    @NotNull
    public static IntStream parallelStream(int @NotNull [] array) {
        return Arrays.stream(array).parallel();
    }

    public static boolean isEmpty(int @NotNull [] array) {
        return array.length == 0;
    }

    public static int size(int @NotNull [] array) {
        return array.length;
    }

    public static int knownSize(int @NotNull [] array) {
        return array.length;
    }

    public static boolean isDefineAt(int @NotNull [] array, int index) {
        return index >= 0 && index <= array.length;
    }

    public static int get(int @NotNull [] array, int index) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Nullable
    public static Integer getOrNull(int @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? Integer.valueOf(array[index]) : null;
    }

    @NotNull
    public static IntOption getOption(int @NotNull [] array, int index) {
        return index >= 0 && index <= array.length ? IntOption.some(array[index]) : IntOption.none();
    }

    public static void set(int @NotNull [] array, int index, int value) {
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    public static int @NotNull [] reversed(int @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            return array;
        }
        int[] res = new int[length];
        for (int i = 0; i < length; ++i) {
            res[i] = array[length - i - 1];
        }
        return res;
    }

    @NotNull
    public static IntIterator reverseIterator(int @NotNull [] array) {
        int length = array.length;
        switch (length) {
            case 0: {
                return IntIterator.empty();
            }
            case 1: {
                return IntIterator.of(array[0]);
            }
        }
        return new ReverseItr(array, length - 1);
    }

    public static void shuffle(int @NotNull [] array) {
        IntArrays.shuffle(array, ThreadLocalRandom.current());
    }

    public static void shuffle(int @NotNull [] array, @NotNull Random random) {
        int size = array.length;
        if (size <= 1) {
            return;
        }
        for (int i = size; i > 1; --i) {
            int k = random.nextInt(i);
            int tmp = array[i - 1];
            array[i - 1] = array[k];
            array[k] = tmp;
        }
    }

    public static void sort(int @NotNull [] array) {
        Arrays.sort(array);
    }

    public static void sort(int @NotNull [] array, int beginIndex, int endIndex) {
        Arrays.sort(array, beginIndex, endIndex);
    }

    @NotNull
    public static IntOption find(int @NotNull [] array, @NotNull IntPredicate predicate) {
        for (int e : array) {
            if (!predicate.test(e)) continue;
            return IntOption.some(e);
        }
        return IntOption.none();
    }

    public static int first(int @NotNull [] array) {
        try {
            return array[0];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    public static int last(int @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        return array[length - 1];
    }

    public static boolean contains(int @NotNull [] array, int value) {
        for (int o : array) {
            if (value != o) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(int @NotNull [] array, int @NotNull [] values) {
        for (int value : values) {
            if (IntArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int @NotNull [] array, @NotNull IntTraversable values) {
        IntIterator it = values.iterator();
        while (it.hasNext()) {
            int value = it.nextInt();
            if (IntArrays.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(int @NotNull [] array, @NotNull IntPredicate predicate) {
        for (int e : array) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(int @NotNull [] array, @NotNull IntPredicate predicate) {
        for (int e : array) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(int @NotNull [] array, @NotNull IntPredicate predicate) {
        for (int e : array) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(int @NotNull [] array, int value) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(int @NotNull [] array, int value, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(int @NotNull [] array, @NotNull IntPredicate predicate) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexWhere(int @NotNull [] array, @NotNull IntPredicate predicate, int beginIndex) {
        int length = array.length;
        if (beginIndex >= length) {
            return -1;
        }
        for (int i = Math.max(beginIndex, 0); i < length; ++i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(int @NotNull [] array, int value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(int @NotNull [] array, int value, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(int @NotNull [] array, @NotNull IntPredicate predicate) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexWhere(int @NotNull [] array, @NotNull IntPredicate predicate, int endIndex) {
        if (endIndex < 0) {
            return -1;
        }
        for (int i = endIndex; i >= 0; --i) {
            if (!predicate.test(array[i])) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int max(int @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        int e = array[0];
        for (int i = 1; i < length; ++i) {
            int v = array[i];
            if (Integer.compare(e, v) >= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Integer maxOrNull(int @NotNull [] array) {
        return array.length != 0 ? Integer.valueOf(IntArrays.max(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static IntOption maxOption(int @NotNull [] array) {
        return array.length != 0 ? IntOption.some(IntArrays.max(array)) : IntOption.none();
    }

    @Contract(pure=true)
    public static int min(int @NotNull [] array) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        int e = array[0];
        for (int i = 1; i < length; ++i) {
            int v = array[i];
            if (Integer.compare(e, v) <= 0) continue;
            e = v;
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Integer minOrNull(int @NotNull [] array) {
        return array.length != 0 ? Integer.valueOf(IntArrays.min(array)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static IntOption minOption(int @NotNull [] array) {
        return array.length != 0 ? IntOption.some(IntArrays.min(array)) : IntOption.none();
    }

    @Contract(pure=true)
    public static int fold(int @NotNull [] array, int zero, @NotNull IntBinaryOperator op) {
        return IntArrays.foldLeft(array, zero, op);
    }

    @Contract(pure=true)
    public static int foldLeft(int @NotNull [] array, int zero, @NotNull IntBinaryOperator op) {
        for (int e : array) {
            zero = op.applyAsInt(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static <U> U foldLeftToObj(int @NotNull [] array, U zero, @NotNull ObjIntBiFunction<U, U> op) {
        for (int e : array) {
            zero = op.apply(zero, e);
        }
        return zero;
    }

    @Contract(pure=true)
    public static int foldRight(int @NotNull [] array, int zero, @NotNull IntBinaryOperator op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.applyAsInt(array[i], zero);
        }
        return zero;
    }

    public static <U> U foldRightToObj(int @NotNull [] array, U zero, @NotNull IntObjBiFunction<U, U> op) {
        for (int i = array.length - 1; i >= 0; --i) {
            zero = op.apply(array[i], zero);
        }
        return zero;
    }

    @Contract(pure=true)
    public static int reduce(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return IntArrays.reduceLeft(array, op);
    }

    @Contract(pure=true)
    @NotNull
    public static IntOption reduceOption(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return IntArrays.reduceLeftOption(array, op);
    }

    @Contract(pure=true)
    public static int reduceLeft(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        int e = array[0];
        for (int i = 1; i < length; ++i) {
            e = op.applyAsInt(e, array[i]);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Integer reduceLeftOrNull(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return array.length != 0 ? Integer.valueOf(IntArrays.reduceLeft(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static IntOption reduceLeftOption(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return array.length != 0 ? IntOption.some(IntArrays.reduceLeft(array, op)) : IntOption.none();
    }

    @Contract(pure=true)
    public static int reduceRight(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        int length = array.length;
        if (length == 0) {
            throw new NoSuchElementException();
        }
        int e = array[length - 1];
        for (int i = length - 2; i >= 0; --i) {
            e = op.applyAsInt(array[i], e);
        }
        return e;
    }

    @Contract(pure=true)
    @Nullable
    public static Integer reduceRightOrNull(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return array.length != 0 ? Integer.valueOf(IntArrays.reduceRight(array, op)) : null;
    }

    @Contract(pure=true)
    @NotNull
    public static IntOption reduceRightOption(int @NotNull [] array, @NotNull IntBinaryOperator op) {
        return array.length != 0 ? IntOption.some(IntArrays.reduceRight(array, op)) : IntOption.none();
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer) {
        return IntArrays.joinTo(array, buffer, ", ", "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer, CharSequence separator) {
        return IntArrays.joinTo(array, buffer, separator, "", "");
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(String.valueOf(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(Objects.toString(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer, @NotNull IntFunction<? extends CharSequence> transform) {
        return IntArrays.joinTo(array, buffer, ", ", "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer, CharSequence separator, @NotNull IntFunction<? extends CharSequence> transform) {
        return IntArrays.joinTo(array, buffer, separator, "", "", transform);
    }

    @NotNull
    public static <A extends Appendable> A joinTo(int @NotNull [] array, @NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull IntFunction<? extends CharSequence> transform) {
        int length = array.length;
        try {
            if (length == 0) {
                buffer.append(prefix).append(postfix);
                return buffer;
            }
            buffer.append(prefix).append(transform.apply(array[0]));
            for (int i = 1; i < length; ++i) {
                buffer.append(separator);
                buffer.append(transform.apply(array[i]));
            }
            buffer.append(postfix);
            return buffer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public static String joinToString(int @NotNull [] array) {
        return IntArrays.joinTo(array, new StringBuilder()).toString();
    }

    @NotNull
    public static String joinToString(int @NotNull [] array, CharSequence separator) {
        return IntArrays.joinTo(array, new StringBuilder(), separator).toString();
    }

    @NotNull
    public static String joinToString(int @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        return IntArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix).toString();
    }

    @NotNull
    public static String joinToString(int @NotNull [] array, @NotNull IntFunction<? extends CharSequence> transform) {
        return IntArrays.joinTo(array, new StringBuilder(), transform).toString();
    }

    @NotNull
    public static String joinToString(int @NotNull [] array, CharSequence separator, @NotNull IntFunction<? extends CharSequence> transform) {
        return IntArrays.joinTo(array, new StringBuilder(), separator, transform).toString();
    }

    @NotNull
    public static String joinToString(int @NotNull [] array, CharSequence separator, CharSequence prefix, CharSequence postfix, @NotNull IntFunction<? extends CharSequence> transform) {
        return IntArrays.joinTo(array, new StringBuilder(), separator, prefix, postfix, transform).toString();
    }

    private static final class Itr
    extends AbstractIntIterator {
        private final int @NotNull [] array;
        private final int endIndex;
        private int index;

        Itr(int @NotNull [] array, int beginIndex, int endIndex) {
            this.array = array;
            this.index = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.endIndex;
        }

        @Override
        public int nextInt() {
            if (this.index >= this.endIndex) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.array[this.index++];
        }
    }

    private static final class ReverseItr
    extends AbstractIntIterator {
        private final int @NotNull [] array;
        private int index;

        ReverseItr(int @NotNull [] array, int index) {
            this.array = array;
            this.index = index;
        }

        ReverseItr(int @NotNull [] array) {
            this(array, array.length - 1);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public int nextInt() {
            try {
                return this.array[this.index--];
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw new NoSuchElementException();
            }
        }
    }
}

