/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.base.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongIterator;
import org.jetbrains.annotations.NotNull;

final class LongIterators {
    static final LongIterator EMPTY = new AbstractLongIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public String toString() {
            return "LongIterator[]";
        }
    };

    LongIterators() {
    }

    static final class Filter
    extends AbstractLongIterator {
        @NotNull
        private final LongIterator source;
        @NotNull
        private final LongPredicate predicate;
        private long nextValue;
        private boolean flag = false;
        private final boolean isFlipped;

        Filter(@NotNull LongIterator source, @NotNull LongPredicate predicate, boolean isFlipped) {
            this.source = source;
            this.predicate = predicate;
            this.isFlipped = isFlipped;
        }

        @Override
        public boolean hasNext() {
            if (this.flag) {
                return true;
            }
            if (!this.source.hasNext()) {
                return false;
            }
            long v = this.source.nextLong();
            while (this.predicate.test(v) == this.isFlipped) {
                if (!this.source.hasNext()) {
                    return false;
                }
                v = this.source.nextLong();
            }
            this.nextValue = v;
            this.flag = true;
            return true;
        }

        @Override
        public long nextLong() {
            if (this.hasNext()) {
                this.flag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Appended
    extends AbstractLongIterator {
        @NotNull
        private final LongIterator source;
        private final long value;
        private boolean flag = true;

        Appended(@NotNull LongIterator source, long value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext() || this.flag;
        }

        @Override
        public long nextLong() {
            if (this.source.hasNext()) {
                return this.source.nextLong();
            }
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Prepended
    extends AbstractLongIterator {
        @NotNull
        private final LongIterator source;
        private final long value;
        private boolean flag = true;

        Prepended(@NotNull LongIterator source, long value) {
            this.source = source;
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.flag || this.source.hasNext();
        }

        @Override
        public long nextLong() {
            if (this.flag) {
                this.flag = false;
                return this.value;
            }
            return this.source.nextLong();
        }
    }

    static final class Updated
    extends AbstractLongIterator {
        @NotNull
        private final LongIterator source;
        private final int n;
        private final long newValue;
        private int idx = 0;

        Updated(@NotNull LongIterator source, int n, long newValue) {
            this.source = source;
            this.n = n;
            this.newValue = newValue;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public long nextLong() {
            if (this.idx++ == this.n) {
                this.source.nextLong();
                return this.newValue;
            }
            return this.source.nextLong();
        }
    }

    static final class TakeWhile
    extends AbstractLongIterator {
        @NotNull
        private LongIterator source;
        private LongPredicate predicate;
        private long nextValue;
        private boolean tag = false;

        TakeWhile(@NotNull LongIterator source, LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.tag) {
                return true;
            }
            if (this.source.hasNext()) {
                this.nextValue = this.source.nextLong();
                long v = this.nextValue;
                if (this.predicate.test(v)) {
                    this.tag = true;
                    return true;
                }
                this.source = EMPTY;
                this.predicate = null;
                return false;
            }
            return false;
        }

        @Override
        public long nextLong() {
            if (this.hasNext()) {
                this.tag = false;
                return this.nextValue;
            }
            throw new NoSuchElementException();
        }
    }

    static final class Take
    extends AbstractLongIterator {
        private final LongIterator source;
        private int n;

        Take(LongIterator source, int n) {
            this.source = source;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n > 0 && this.source.hasNext();
        }

        @Override
        public long nextLong() {
            if (this.hasNext()) {
                --this.n;
                return this.source.nextLong();
            }
            throw new NoSuchElementException();
        }
    }

    static final class ConcatAll
    extends AbstractLongIterator {
        @NotNull
        private final Iterator<? extends LongIterator> iterators;
        private LongIterator current = null;

        ConcatAll(@NotNull Iterator<? extends LongIterator> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this + ".next()");
            }
            return this.current.nextLong();
        }
    }

    static final class Concat
    extends AbstractLongIterator {
        private LongIterator it1;
        private LongIterator it2;

        Concat(LongIterator it1, LongIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public boolean hasNext() {
            if (this.it1 != null) {
                if (this.it1.hasNext()) {
                    return true;
                }
                this.it1 = null;
            }
            if (this.it2 != null) {
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
            }
            return false;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.it1 != null) {
                return this.it1.nextLong();
            }
            if (this.it2 != null) {
                return this.it2.nextLong();
            }
            throw new AssertionError();
        }
    }
}

