/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.factory.primitive;

import java.util.Objects;
import java.util.function.Function;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.PrimitiveCollectionFactory;
import kala.function.CharSupplier;
import org.jetbrains.annotations.NotNull;

public interface CharCollectionFactory<Builder, R>
extends PrimitiveCollectionFactory<Character, Builder, R> {
    public static <Builder, R> CharCollectionFactory<Builder, R> narrow(CharCollectionFactory<Builder, ? extends R> factory) {
        return factory;
    }

    @Override
    public void addToBuilder(@NotNull Builder var1, char var2);

    @Override
    default public void addToBuilder(@NotNull Builder builder, Character value) {
        this.addToBuilder(builder, value.charValue());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull CharTraversable values) {
        this.addAllToBuilder(builder, values.iterator());
    }

    default public void addAllToBuilder(@NotNull Builder builder, @NotNull CharIterator it) {
        while (it.hasNext()) {
            this.addToBuilder(builder, it.nextChar());
        }
    }

    default public void addAllToBuilder(@NotNull Builder builder, char @NotNull [] values) {
        Objects.requireNonNull(values);
        for (char value : values) {
            this.addToBuilder(builder, value);
        }
    }

    @Override
    default public R fill(int n, char value) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, value);
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, CharSupplier supplier) {
        if (n <= 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, n);
        for (int i = 0; i < n; ++i) {
            this.addToBuilder((Builder)builder, supplier.getAsChar());
        }
        return this.build(builder);
    }

    @Override
    default public R fill(int n, Character value) {
        return this.fill(n, value.charValue());
    }

    default public R from(char @NotNull [] values) {
        if (values.length == 0) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.sizeHint(builder, values.length);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull CharTraversable values) {
        Object builder = this.newBuilder();
        this.sizeHint(builder, values);
        this.addAllToBuilder(builder, values);
        return this.build(builder);
    }

    default public R from(@NotNull CharIterator it) {
        if (!it.hasNext()) {
            return this.empty();
        }
        Object builder = this.newBuilder();
        this.addAllToBuilder(builder, it);
        return this.build(builder);
    }

    @Override
    @NotNull
    default public <U> CharCollectionFactory<Builder, U> mapResult(final @NotNull Function<? super R, ? extends U> mapper) {
        final CharCollectionFactory self = this;
        return new CharCollectionFactory<Builder, U>(){

            @Override
            public void addToBuilder(@NotNull Builder builder, char value) {
                self.addToBuilder(builder, value);
            }

            @Override
            public Builder newBuilder() {
                return self.newBuilder();
            }

            @Override
            public U build(Builder builder) {
                return mapper.apply(self.build(builder));
            }

            @Override
            public Builder mergeBuilder(@NotNull Builder builder1, @NotNull Builder builder2) {
                return self.mergeBuilder(builder1, builder2);
            }
        };
    }
}

