/*
 * Decompiled with CFR 0.152.
 */
package kala.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;

public enum Granularity {
    ATOM,
    VERY_FINE,
    FINE,
    MEDIUM,
    COARSE,
    VERY_COARSE;

    public static final Granularity DEFAULT;

    public int pieceSize(int sizeEstimate) {
        return this.pieceSize(ForkJoinPool.getCommonPoolParallelism(), sizeEstimate);
    }

    public int pieceSize(int threadCount, int sizeEstimate) {
        if (this == ATOM) {
            return 1;
        }
        int pieceCount = threadCount;
        switch (this) {
            case VERY_FINE: {
                pieceCount <<= 6;
            }
            case FINE: {
                pieceCount <<= 4;
                break;
            }
            case MEDIUM: {
                pieceCount <<= 2;
                break;
            }
            case VERY_COARSE: {
                pieceCount >>>= 2;
            }
        }
        return Integer.max(1, sizeEstimate / pieceCount);
    }

    public int pieceSize(Executor executor, int sizeEstimate) {
        if (this == ATOM) {
            return 1;
        }
        int pieceCount = executor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)executor).getMaximumPoolSize() : (executor instanceof ForkJoinPool ? ((ForkJoinPool)executor).getParallelism() : ForkJoinPool.getCommonPoolParallelism());
        switch (this) {
            case VERY_FINE: {
                pieceCount <<= 6;
            }
            case FINE: {
                pieceCount <<= 4;
                break;
            }
            case MEDIUM: {
                pieceCount <<= 2;
                break;
            }
            case VERY_COARSE: {
                pieceCount >>>= 2;
            }
        }
        return Integer.max(1, sizeEstimate / pieceCount);
    }

    static {
        DEFAULT = MEDIUM;
    }
}

